(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19468,        480]
NotebookOptionsPosition[     18981,        460]
NotebookOutlinePosition[     19317,        475]
CellTagsIndexPosition[     19274,        472]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"fu", "=."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "[", 
   RowBox[{"fu_", ",", "p_"}], "]"}], ":=", " ", 
  RowBox[{"Maximize", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", " ", "p"}], " ", "-", 
     RowBox[{"fu", "[", "x", "]"}]}], ",", "x"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xmindef", "=", 
   RowBox[{"-", "5"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xmaxdef", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"fmindef", ":=", 
  RowBox[{
   RowBox[{"Min", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"fstar", "[", 
       RowBox[{"po", "[", "xmindef", "]"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"fstar", "[", 
       RowBox[{"po", "[", "xmaxdef", "]"}], "]"}]}], ",", "0"}], "]"}], "-", 
   "3"}]}], "\[IndentingNewLine]", 
 RowBox[{"fmaxdef", ":=", 
  RowBox[{
   RowBox[{"Max", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"fstar", "[", 
       RowBox[{"po", "[", "xmindef", "]"}], "]"}], "+", 
      RowBox[{"f", "[", "xmindef", "]"}]}], ",", 
     RowBox[{
      RowBox[{"fstar", "[", 
       RowBox[{"po", "[", "xmaxdef", "]"}], "]"}], "+", 
      RowBox[{"f", "[", "xmaxdef", "]"}]}], ",", "0"}], "]"}], "+", 
   "3"}]}], "\[IndentingNewLine]", 
 RowBox[{"fstarmindef", ":=", 
  RowBox[{
   RowBox[{"Min", "[", 
    RowBox[{
     RowBox[{"fstar", "[", 
      RowBox[{"po", "[", "xmindef", "]"}], "]"}], ",", 
     RowBox[{"fstar", "[", 
      RowBox[{"po", "[", "xmaxdef", "]"}], "]"}], ",", 
     RowBox[{
      RowBox[{"Minimize", "[", 
       RowBox[{
        RowBox[{"fstar", "[", "p", "]"}], ",", "p"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", "0"}], "]"}], "-", 
   "3"}]}], "\[IndentingNewLine]", 
 RowBox[{"fstarmaxdef", ":=", 
  RowBox[{
   RowBox[{"Max", "[", 
    RowBox[{
     RowBox[{"fstar", "[", 
      RowBox[{"po", "[", "xmindef", "]"}], "]"}], ",", 
     RowBox[{"fstar", "[", 
      RowBox[{"po", "[", "xmaxdef", "]"}], "]"}], ",", "0"}], "]"}], "+", 
   "3"}]}]}], "Input",
 CellChangeTimes->{{3.497246164486754*^9, 3.497246194385778*^9}, {
  3.497246238862298*^9, 3.497246336515057*^9}, {3.49724645616431*^9, 
  3.4972464819208107`*^9}, {3.497246648574957*^9, 3.497246653388234*^9}, {
  3.4972466950760717`*^9, 3.497246704909012*^9}, {3.497246771761655*^9, 
  3.497246783993238*^9}, {3.497246873951185*^9, 3.497246875048641*^9}, {
  3.497246933895433*^9, 3.497246974732789*^9}, {3.497247037766396*^9, 
  3.497247038058463*^9}, {3.497247365774713*^9, 3.497247398041754*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x_", "]"}], "=", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "/", "2"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"f", "[", "x_", "]"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "/", "2"}], "+", "5"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"f", "[", "x_", "]"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "/", "2"}], "-", "5"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"f", "[", "x_", "]"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "/", "2"}], "+", "5", "-", 
      RowBox[{"2", "x"}]}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x_", "]"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "+", "3"}], ")"}], "^", "2"}], "/", "9"}], "+", "6"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fstar", "[", "p_", "]"}], "=", 
    RowBox[{
     RowBox[{"L", "[", 
      RowBox[{"f", ",", "p"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"po", "[", "a_", "]"}], ":=", 
     RowBox[{
      RowBox[{"f", "'"}], "[", "a", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xmin", "=", "xmindef"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xmax", "=", "xmaxdef"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fmin", "=", "fmindef"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fmax", "=", "fmaxdef"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"fstarmin", "=", "fstarmindef"}], "\[IndentingNewLine]", 
   RowBox[{"fstarmax", "=", "fstarmaxdef"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Show", "[", "\[IndentingNewLine]", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Plot", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"po", "[", "xo", "]"}], "x"}], ",", 
              RowBox[{"f", "[", "x", "]"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{"po", "[", "xo", "]"}], "x"}], "-", 
               RowBox[{"fstar", "[", 
                RowBox[{"po", "[", "xo", "]"}], "]"}]}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
            RowBox[{"ImageSize", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"500", ",", 
               RowBox[{"500", "/", "GoldenRatio"}]}], "}"}]}], ",", 
            RowBox[{"AspectRatio", "\[Rule]", 
             RowBox[{"1", "/", "GoldenRatio"}]}], ",", 
            RowBox[{"PlotRange", "->", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"xmin", ",", "xmax"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"fmin", ",", "fmax"}], "}"}]}], "}"}]}]}], "]"}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"xo", ",", 
                RowBox[{"f", "[", "xo", "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"xo", ",", 
                RowBox[{
                 RowBox[{"po", "[", "xo", "]"}], "xo"}]}], "}"}]}], "}"}], 
            "]"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"-", 
                   RowBox[{"fstar", "[", 
                    RowBox[{"po", "[", "xo", "]"}], "]"}]}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"xo", ",", 
                  RowBox[{"f", "[", "xo", "]"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"xo", ",", 
                  RowBox[{
                   RowBox[{"po", "[", "xo", "]"}], "xo"}]}], "}"}]}], "}"}], 
              "]"}]}], "}"}], "]"}]}], "\[IndentingNewLine]", "}"}], "]"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"Show", "[", "\[IndentingNewLine]", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Plot", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"fstar", "[", "p", "]"}], ",", 
              RowBox[{"Piecewise", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"fstar", "[", "p", "]"}], ",", 
                   RowBox[{"p", "<", 
                    RowBox[{"po", "[", "xo", "]"}]}]}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"i", " ", 
                    RowBox[{"fstar", "[", "p", "]"}]}], ",", 
                   RowBox[{"p", "\[GreaterEqual]", 
                    RowBox[{"po", "[", "xo", "]"}]}]}], "}"}]}], "}"}], 
               "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"p", ",", 
              RowBox[{"po", "[", 
               RowBox[{"-", "5"}], "]"}], ",", 
              RowBox[{"po", "[", "5", "]"}]}], "}"}], ",", 
            RowBox[{"PlotRange", "->", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"po", "[", "xmin", "]"}], ",", 
                 RowBox[{"po", "[", "xmax", "]"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"fstarmin", ",", "fstarmax"}], "}"}]}], "}"}]}], ",", 
            " ", 
            RowBox[{"AxesOrigin", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}]}], ",", 
            RowBox[{"PlotStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Transparent", ",", "Black"}], "}"}]}], ",", 
            RowBox[{"ImageSize", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"500", ",", 
               RowBox[{"500", "/", "GoldenRatio"}]}], "}"}]}], ",", 
            RowBox[{"AspectRatio", "\[Rule]", 
             RowBox[{"1", "/", "GoldenRatio"}]}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"po", "[", "xo", "]"}], ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"po", "[", "xo", "]"}], ",", 
                RowBox[{"fstar", "[", 
                 RowBox[{"po", "[", "xo", "]"}], "]"}]}], "}"}]}], "}"}], 
            "]"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"po", "[", "xo", "]"}], ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"po", "[", "xo", "]"}], ",", 
                  RowBox[{"fstar", "[", 
                   RowBox[{"po", "[", "xo", "]"}], "]"}]}], "}"}]}], "}"}], 
              "]"}]}], "}"}], "]"}]}], "\[IndentingNewLine]", "}"}], "]"}]}], 
      "\[IndentingNewLine]", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"xo", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.497093236022459*^9, {3.497093312930725*^9, 3.4970933183388433`*^9}, {
   3.497093359744574*^9, 3.497093440301886*^9}, {3.4970935764853277`*^9, 
   3.4970935808659554`*^9}, 3.4970936205866203`*^9, {3.4970937045642967`*^9, 
   3.4970937048393097`*^9}, {3.497246349000087*^9, 3.497246406890503*^9}, {
   3.497246497332683*^9, 3.497246518365892*^9}, {3.4972465895710793`*^9, 
   3.497246629170146*^9}, {3.497246715931265*^9, 3.497246743606723*^9}, {
   3.497246808009554*^9, 3.497246862091308*^9}, {3.497246994753181*^9, 
   3.497247019256414*^9}, {3.4972470540620604`*^9, 3.497247072229597*^9}, {
   3.4972471526048527`*^9, 3.497247229107068*^9}, {3.4972472614384823`*^9, 
   3.49724727258794*^9}, {3.4972473131515512`*^9, 3.49724733972431*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "24"}], "-", 
    RowBox[{"12", " ", "p"}], "+", 
    RowBox[{"9", " ", 
     SuperscriptBox["p", "2"]}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.497093137318952*^9, 3.4970932371026287`*^9, 3.4970933192076273`*^9, {
   3.497093375578277*^9, 3.4970934185179863`*^9}, 3.4970935819447327`*^9, 
   3.4970937059815683`*^9, 3.497093822091928*^9, {3.497093909806809*^9, 
   3.497093925364214*^9}, 3.4972461296054783`*^9, {3.497246408334326*^9, 
   3.4972464167473717`*^9}, 3.4972464836649733`*^9, 3.497246523422814*^9, 
   3.497246591588437*^9, {3.497246709514041*^9, 3.497246791014141*^9}, {
   3.49724682171205*^9, 3.497246880010581*^9}, {3.497246979126029*^9, 
   3.497247073125825*^9}, {3.497247201614276*^9, 3.497247229776956*^9}, 
   3.497247273367243*^9, {3.4972473140353527`*^9, 3.497247340633061*^9}, {
   3.497247372816763*^9, 3.49724740059365*^9}}],

Cell[BoxData[
 RowBox[{"-", "10"}]], "Output",
 CellChangeTimes->{
  3.497093137318952*^9, 3.4970932371026287`*^9, 3.4970933192076273`*^9, {
   3.497093375578277*^9, 3.4970934185179863`*^9}, 3.4970935819447327`*^9, 
   3.4970937059815683`*^9, 3.497093822091928*^9, {3.497093909806809*^9, 
   3.497093925364214*^9}, 3.4972461296054783`*^9, {3.497246408334326*^9, 
   3.4972464167473717`*^9}, 3.4972464836649733`*^9, 3.497246523422814*^9, 
   3.497246591588437*^9, {3.497246709514041*^9, 3.497246791014141*^9}, {
   3.49724682171205*^9, 3.497246880010581*^9}, {3.497246979126029*^9, 
   3.497247073125825*^9}, {3.497247201614276*^9, 3.497247229776956*^9}, 
   3.497247273367243*^9, {3.4972473140353527`*^9, 3.497247340633061*^9}, {
   3.497247372816763*^9, 3.49724740065965*^9}}],

Cell[BoxData["3"], "Output",
 CellChangeTimes->{
  3.497093137318952*^9, 3.4970932371026287`*^9, 3.4970933192076273`*^9, {
   3.497093375578277*^9, 3.4970934185179863`*^9}, 3.4970935819447327`*^9, 
   3.4970937059815683`*^9, 3.497093822091928*^9, {3.497093909806809*^9, 
   3.497093925364214*^9}, 3.4972461296054783`*^9, {3.497246408334326*^9, 
   3.4972464167473717`*^9}, 3.4972464836649733`*^9, 3.497246523422814*^9, 
   3.497246591588437*^9, {3.497246709514041*^9, 3.497246791014141*^9}, {
   3.49724682171205*^9, 3.497246880010581*^9}, {3.497246979126029*^9, 
   3.497247073125825*^9}, {3.497247201614276*^9, 3.497247229776956*^9}, 
   3.497247273367243*^9, {3.4972473140353527`*^9, 3.497247340633061*^9}, {
   3.497247372816763*^9, 3.497247400729805*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`xo$$ = 2.46, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`xo$$], -5, 5}}, Typeset`size$$ = {
    516.5, {494., 156.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`xo$22113$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`xo$$ = -5}, 
      "ControllerVariables" :> {
        Hold[$CellContext`xo$$, $CellContext`xo$22113$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> {
        Show[{
          Plot[{$CellContext`po[$CellContext`xo$$] $CellContext`x, 
            $CellContext`f[$CellContext`x], \
$CellContext`po[$CellContext`xo$$] $CellContext`x - $CellContext`fstar[
             $CellContext`po[$CellContext`xo$$]]}, {$CellContext`x, -5, 5}, 
           ImageSize -> {500, 500/GoldenRatio}, AspectRatio -> 1/GoldenRatio, 
           PlotRange -> {{$CellContext`xmin, $CellContext`xmax}, \
{$CellContext`fmin, $CellContext`fmax}}], 
          Graphics[
           Line[{{$CellContext`xo$$, 
              $CellContext`f[$CellContext`xo$$]}, {$CellContext`xo$$, \
$CellContext`po[$CellContext`xo$$] $CellContext`xo$$}}]], 
          Graphics[{
            PointSize[Medium], 
            Point[{{0, 0}, {0, -$CellContext`fstar[
                 $CellContext`po[$CellContext`xo$$]]}, {$CellContext`xo$$, 
               $CellContext`f[$CellContext`xo$$]}, {$CellContext`xo$$, \
$CellContext`po[$CellContext`xo$$] $CellContext`xo$$}}]}]}], 
        Show[{
          Plot[{
            $CellContext`fstar[$CellContext`p], 
            Piecewise[{{
               $CellContext`fstar[$CellContext`p], $CellContext`p < \
$CellContext`po[$CellContext`xo$$]}, {$CellContext`i \
$CellContext`fstar[$CellContext`p], $CellContext`p >= \
$CellContext`po[$CellContext`xo$$]}}]}, {$CellContext`p, 
            $CellContext`po[-5], 
            $CellContext`po[5]}, PlotRange -> {{
              $CellContext`po[$CellContext`xmin], 
              $CellContext`po[$CellContext`xmax]}, {$CellContext`fstarmin, \
$CellContext`fstarmax}}, AxesOrigin -> {0, 0}, 
           PlotStyle -> {Transparent, Black}, 
           ImageSize -> {500, 500/GoldenRatio}, AspectRatio -> 1/GoldenRatio], 
          Graphics[
           Line[{{
              $CellContext`po[$CellContext`xo$$], 0}, {
              $CellContext`po[$CellContext`xo$$], 
              $CellContext`fstar[
               $CellContext`po[$CellContext`xo$$]]}}]], 
          Graphics[{
            PointSize[Medium], 
            Point[{{
               $CellContext`po[$CellContext`xo$$], 0}, {
               $CellContext`po[$CellContext`xo$$], 
               $CellContext`fstar[
                $CellContext`po[$CellContext`xo$$]]}}]}]}]}, 
      "Specifications" :> {{$CellContext`xo$$, -5, 5}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{562., {367., 372.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.497093137318952*^9, 3.4970932371026287`*^9, 3.4970933192076273`*^9, {
   3.497093375578277*^9, 3.4970934185179863`*^9}, 3.4970935819447327`*^9, 
   3.4970937059815683`*^9, 3.497093822091928*^9, {3.497093909806809*^9, 
   3.497093925364214*^9}, 3.4972461296054783`*^9, {3.497246408334326*^9, 
   3.4972464167473717`*^9}, 3.4972464836649733`*^9, 3.497246523422814*^9, 
   3.497246591588437*^9, {3.497246709514041*^9, 3.497246791014141*^9}, {
   3.49724682171205*^9, 3.497246880010581*^9}, {3.497246979126029*^9, 
   3.497247073125825*^9}, {3.497247201614276*^9, 3.497247229776956*^9}, 
   3.497247273367243*^9, {3.4972473140353527`*^9, 3.497247340633061*^9}, {
   3.497247372816763*^9, 3.4972474008331327`*^9}}]
}, Open  ]]
},
WindowSize->{929, 901},
WindowMargins->{{92, Automatic}, {Automatic, 0}},
FrontEndVersion->"7.0 for Linux x86 (64-bit) (November 11, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 2611, 72, 209, "Input"],
Cell[CellGroupData[{
Cell[3181, 96, 8893, 224, 737, "Input"],
Cell[12077, 322, 958, 19, 46, "Output"],
Cell[13038, 343, 777, 12, 31, "Output"],
Cell[13818, 357, 760, 11, 31, "Output"],
Cell[14581, 370, 4384, 87, 756, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
