% Statistical Physics HS 11
% Exercise 2.1
% The code compute the number of needles, the polarization and the entropy
% using finite diferences method for two cases:
%   a) when the fluctuations are neglected.
%   a) when the fluctuations are considered.

%%%%%%%%%% READ ME %%%%%%%%%%%%%%%%
% Change: z, N_c, p, IC, t_steps  %
%%%%%%%%%% READ ME %%%%%%%%%%%%%%%%

clear all
clf('reset')

%%%%%%%%%%%%%%%%%%%%%%%%
%%% INPUT PARAMETERS %%%
% z - number of directions (micro-states)
% N_c - number of compasses
% IC - initial configuration
% N[x,i] - number of compasses in the micro-state x at time step i, i=1
% represent the initial configuration
% Gamma - transition rate
% deltaT - interval between two consecutive discrete time steps
% p=Gamma*deltaT - transition probability < 0.5
% t_steps - number of steps
% The problem is solved simply computing the number of compasses along each
% direction using the relation:
% N[x,i+1]=N[x,i]+p*(N[x+1,i]+N[x-1,i]-2*N[x,i])


% Parameters
z=10;
N_c=40;
p=0.1;
IC='a';
t_steps=500;

t_vector=1:t_steps;
N(1:z,1:t_steps)=0;
N_fluct(1:z,1:t_steps)=0;

% Initial configuration
switch IC
    case 'a' % Uniformly distributed on all microstates (equilibrium)
        N(1:z,1)=N_c/z; %2.1.a)
        N_fluct(1:z,1)=N_c/z; %2.1.a)
    case 'b' % Uniformly distribution on first half of the microstates
        N(1:z/2,1)=2*N_c/z; %2.1.b)
        N_fluct(1:z/2,1)=2*N_c/z; %2.1.b)
    case 'c' % All needles on the first microstate
        N(1,1)=N_c; %2.1.c)
        N_fluct(1,1)=N_c; %2.1.c)
    otherwise
        error('The initial condition could be a, b or c');
end
z_vector=1:z;

if(p>0.5)
    error('The transition probability should be smaller than 0.5');
end
if(z<1 || N_c < 0)
    error('The number of microstates should be at least 1');
end
if(N_c < 0)
    error('The number of needles should be at least 0');
end

H(1:t_steps)=0;
H_fluct(1:t_steps)=0;

P(1:t_steps)=0;
P_fluct(1:t_steps)=0;


H(1)=Entropy(N(:,1),N_c);
P(1)=Polarization(N(:,1),N_c,z);

H_fluct(1)=Entropy(N_fluct(:,1),N_c);
P_fluct(1)=Polarization(N_fluct(:,1),N_c,z);

rng('default')

N_change=zeros(z,2);

needle=inverse_N_function(N(:,1),N_c,z);

for i=1:t_steps-1
    
    N(:,i+1)=N(:,i)+p*(circshift(N(:,i),1)+circshift(N(:,i),-1)-2*N(:,i));
    H(i+1)=Entropy(N(:,i+1),N_c);
    P(i+1)=Polarization(N(:,i+1),N_c,z);
    
    Prob_tot=rand(N_c,1);
    Prob_tot=(-1)*(Prob_tot<p)+(Prob_tot>=p & Prob_tot<2*p);
    needle=mod((needle+Prob_tot),z);
    
    
    N_fluct(:,i+1)=N_function(needle,z);
    H_fluct(i+1)=Entropy(N_fluct(:,i+1),N_c);
    P_fluct(i+1)=Polarization(N_fluct(:,i+1),N_c,z);
end

subplot(2,1,1);
plot(t_vector,H,t_vector,H_fluct);
xlabel('time');
ylabel('Entropy');
axis([1 t_steps 0 log(z)*1.05])
title(['z=',num2str(z)]);
subplot(2,1,2);
plot(t_vector,P,t_vector,P_fluct);
xlabel('time');
ylabel('Polarization');
axis([1 t_steps -1 1])


