#include <iostream>
#include <cmath>
#include <vector>
#include <algorithm>
#include <numeric>
#include <iterator>

#include "exponential-of-minus-x.h"

//
// Objective:
// -- Want to evaluate the partition function Z = \sum ( exp (-beta E) )
// -- assume beta = 1
// -- use 1D Quantum Harmonic Oscillator (hbar = 1 , omega = 1)
// -- E = 0.5, 1.5, 2.5, ...
//

int main(int argc, char** argv)
{
	std::vector<double> E;
	E.push_back(0.5);
	E.push_back(1.5);
	E.push_back(2.5);
	E.push_back(3.5);

	double E_sum 	=	std::accumulate
 		               	( E.begin()
 		               	, E.end()
	 	               	, 0.
										,	std::plus<double>()
										);

	double E_prod 	=	std::accumulate
 		               	( E.begin()
 		               	, E.end()
	 	               	, 1.
										,	std::multiplies<double>()
										);


	double Z = std::accumulate
							(	E.begin()
							,	E.end()
							,	0.
							,	&programming_techniques::add_y_to_exponential_of_minus_x<double>
							);



	std::cout << "E = ";
	std::copy(E.begin(), E.end(), std::ostream_iterator<double>(std::cout,"\t"));
	std::cout << "\n";

	std::cout << "E (sum) = " << E_sum	<< std::endl;
	std::cout << "E (prod) = " << E_prod	<< std::endl;
	std::cout << "My great partition function Z = " << Z << std::endl;



  return 0;
} 

