#ifndef EX1_HPP
#define EX1_HPP

#include "include/cdefine.hpp"
#include "include/include.hpp"


namespace programming_techniques
{
	struct integrator
	{
		template <class T>
		static T right_rectangular(std::vector<T> const & x, std::vector<T> const & integrand)
		{
			std::vector<T> _delta_x;
			std::adjacent_difference(x.begin(), x.end(), std::back_inserter(_delta_x));
			*_delta_x.begin() = 0.;     // _delta_x[0] = 0.;

#ifdef DEBUGMODE			
			std::cout << "_delta_x = ";
			std::copy(_delta_x.begin(), _delta_x.end(), std::ostream_iterator<T>(std::cout,"\t"));
			std::cout << "\n";
#endif
		
			// Note: The following is not beautiful, and we will beautify it with boost algorithm library in future...
			std::vector<T> _delta_x_multiply_with_integrand;
			std::transform(integrand.begin(), integrand.end(), _delta_x.begin(), std::back_inserter(_delta_x_multiply_with_integrand), std::multiplies<T>());     

#ifdef DEBUGMODE      
      std::cout << "_delta_x * integrand = ";
      std::copy(_delta_x_multiply_with_integrand.begin(), _delta_x_multiply_with_integrand.end(), std::ostream_iterator<T>(std::cout,"\t"));
      std::cout << "\n";
#endif

			return std::accumulate(_delta_x_multiply_with_integrand.begin(), _delta_x_multiply_with_integrand.end(), 0.);

		}
	};


} // ending namespace programming_techniques

#endif
