#ifndef EX1_CPP
#define EX1_CPP

#include "src/rectangular-integration.hpp"

int main(int argc, char** argv)
{
	typedef int 		size_type;
	typedef int 		index_type;
	typedef double	value_type;

	std::vector<value_type>	x;
	std::vector<value_type> f;

	size_type N;

	std::cout << "Please enter the number of grid points:\t";
	std::cin >> N;
	std::cout << "\n";

	for (index_type index=0; index <= N; ++index)
	{
		x.push_back(static_cast<value_type>(index*PI)/N);
	}

	std::transform(x.begin(), x.end(), std::back_inserter(f), static_cast<value_type (*)(value_type)>(&std::sin));

#ifdef DEBUGMODE
	std::cout << "x = ";
	std::copy(x.begin(), x.end(), std::ostream_iterator<value_type>((std::cout),"\t"));
	std::cout << "\n";
	std::cout << "f(x) = ";
  std::copy(f.begin(), f.end(), std::ostream_iterator<value_type>((std::cout),"\t"));
	std::cout << "\n";
#endif
	
	value_type	result;
	result =  programming_techniques::integrator::right_rectangular<value_type>(x,f);   // programming_techniques::integrator::right_rectangular(x,f);
	
  std::cout << "The integrated result is " << result << "\n\n";


  return 0;
}

#endif
