#include <iostream>
#include <cmath>
#include <vector>
#include <set>
#include <algorithm>


#include <boost/random.hpp>


class Random_Uniform_Non_Negative_Integer
{
public:
	typedef 	unsigned int	value_type;
  typedef   boost::lagged_fibonacci607
                        	sequence_type;
  typedef   boost::uniform_int<>
                        	distribution_type;
  typedef   boost::variate_generator<sequence_type&, distribution_type>
                        	random_number_generator_type;


	Random_Uniform_Non_Negative_Integer
		(	value_type	upper_bound =	(1<<8)    // default: 1 byte = 8 bits
		)
		:	_sequence(sequence_type(40u))
		,	_random(_sequence, distribution_type(0, upper_bound))
		{}

  value_type
    operator()
     ()
    {
      return _random();
    }


private:  
  sequence_type                 _sequence;
  random_number_generator_type  _random;

};


int main(int argc, char** argv)
{
	Random_Uniform_Non_Negative_Integer random(2000);


	// Generate 1000 random numbers (can be repeated)
	std::vector<unsigned int> random_vector_A(1000);	

  std::generate(random_vector_A.begin(), random_vector_A.end(), random);

  std::cout << "My nice random vector A = \t";
	std::copy(random_vector_A.begin(), random_vector_A.end(), std::ostream_iterator<unsigned int>(std::cout, "\t"));
	std::cout << "\n";


	// Generate 1000 random numbers (cannot be repeated)
	std::set<unsigned int>	random_set_B;
	while (random_set_B.size() < 1000)
	{
    random_set_B.insert(random());
	}
	
  std::cout << "My nice random set B = \t";
	std::copy(random_set_B.begin(), random_set_B.end(), std::ostream_iterator<unsigned int>(std::cout, "\t"));
	std::cout << "\n";

	std::cout << "No. of elements in B = " << random_set_B.size() << std::endl;

	return 0;
};

