#include <iostream>
#include <cmath>
#include <vector>
#include <algorithm>
#include <numeric>
#include <iterator>

#include <boost/iterator/counting_iterator.hpp>
#include <boost/bind.hpp>
#include <boost/lambda/lambda.hpp>

//
// Objective:
// -- Want to evaluate the specific heat C = beta^2 ( <E**2> - <E>**2 )
// -- use 1D Quantum Harmonic Oscillator (hbar = 1 , omega = 1) (2000 states)
// -- E = 0.5, 1.5, 2.5, ..., 1999.5
//

int main(int argc, char** argv)
{
	//	Step 0 	: Initialize cutoff energy level and temperature
	int 		N 		= 20;
	double 	T			=	1.;
	double	beta	=	1./T;

	//	Step 1	:	Setup E and E^2 vector arrays	
	std::vector<double> E;
	std::vector<double> E_sq;

	std::transform
		(	boost::counting_iterator<int>(0)	,	boost::counting_iterator<int>(N) 
		,	std::back_inserter(E)
		,	boost::lambda::_1 + 0.5
		);

	std::transform
		(	E.begin()	,	E.end()
		,	std::back_inserter(E_sq)
		,	boost::lambda::_1 * boost::lambda::_1
		);

#ifdef PRINT_EVERYTHING
	std::cout << "E =\t";
	std::copy
		(	E.begin()	,	E.end()
		,	std::ostream_iterator<double>
				(	std::cout
				,	"\t"
				)
		);
	std::cout << "\n";

	std::cout << "E^2 =\t";
	std::copy
		(	E_sq.begin()	,	E_sq.end()
		,	std::ostream_iterator<double>
				(	std::cout
				,	"\t"
				)
		);
	std::cout << "\n";
#endif

	//	Step 2	:	Evaulate <E> and <E^2>
	//	--To be done in next tutorial


  return 0;
} 

