#include "simpson_virt.h"

double simpson_virt::integrate(const double a, const double b, const unsigned int N) {
	double result = (*this)(a) + (*this)(b);
	double h = (b-a)/N;
	
	int sign = 1;
	for (int i = 1; i < N; ++i) 
		result += (3-(sign*=-1)) * (*this)(a+i*h);
	
	result *= h/3.0;
	return result;
}

double my::operator()(double x) { return x*x; }
