enum op { Plus, Mul };

template<class T>
class Constant
    {
    public:
        typedef T value_type;
        
        Constant(T initial = T()) 
    	: _val(initial) 
        {}
        
        Constant<T>& operator=(const T& o) 
        { 
            _val = o; 
            return *this; 
        }
        
        T operator()(T /* unused */) 
        { 
            return _val; 
        }
        
        T derivative(T)
        {
            return 0;
        }
        
    private:
        T _val;
    };

template <class T>
Constant<T> constant(T x)
{
    return Constant<T>(x);
}

class Placeholder
    {
    public:
        Placeholder() {}
        
        template <class T>
        T operator()(T x) { return x; }
        
        template <class T>
        T derivative(T x)
        {
            return T(1);
        }
    };
Placeholder x;

template<class left, class right, op o>
class Expression
    {
    public:
        Expression(left _l, right _r) : l(_l), r(_r) { }
        
        template <class T>
        T operator()(T x)
        {
            switch (o)
            {
                case Plus:
                    return l(x) + r(x);
                    break;
                case Mul:
                    return l(x) * r(x);
                    break;
            }
        }
        
        template <class T>
        T derivative(T x)
        {
            switch (o)
            {
                case Plus:
//                    $FILLME$
                    break;
                case Mul:
//                    $FILLME$
                    break;
            }
        }
        
    private:
        left l;
        right r;
    };

template<class L, class R> Expression<L, R, Mul>
operator*(L l, R r)
{
	return Expression<L, R, Mul>(l, r);
}

template<class L, class R> Expression<L, R, Plus>
operator+(L l, R r)
{
	return Expression<L, R, Plus>(l, r);
}
