#include <iostream>
#include <fstream>
#include <sys/time.h>

using namespace std;

#include "simpson_virt.h"
#include "simpson_tpl.h"
#include "functions.h"

int perform(double a, double b, const unsigned int N, const unsigned int iter)
{
	timeval start, end;
	double s = 0;
	
	cout << "Function pointer: ";
	gettimeofday(&start, NULL);
	for (int i = 0; i < iter; i++)
		s += simpson_tpl(&function, a, b, N);
	gettimeofday(&end, NULL);
	cout << end.tv_sec-start.tv_sec+1e-6*(end.tv_usec-start.tv_usec) << endl;
	
	cout << "Functor: ";
	gettimeofday(&start, NULL);
	for (int i = 0; i < iter; i++)
		s += simpson_tpl(functor(), a, b, N);
	gettimeofday(&end, NULL);
	cout << end.tv_sec-start.tv_sec+1e-6*(end.tv_usec-start.tv_usec) << endl;
	
	cout << "Virtual: ";
	simpson_virt *virt = new my;
	gettimeofday(&start, NULL);
	for (int i = 0; i < iter; i++)
		s += virt->integrate(a, b, N);
	gettimeofday(&end, NULL);
	cout << end.tv_sec-start.tv_sec+1e-6*(end.tv_usec-start.tv_usec) << endl;
	
	ofstream("/dev/null") << s;
}

int main()
{
	perform(0, 1, 1e6, 100);
}
