// functor
template <class F>
double simpson_tpl(F f, const double a, const double b, const unsigned int N) {
	double result = f(a) + f(b);
	double h = (b-a)/N;
	
	int sign = 1;
	for (int i = 1; i < N; ++i) 
		result += (3-(sign*=-1)) * f(a+i*h);
	
	result *= h/3.0;
	return result;
}
