(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    116517,       2227]
NotebookOptionsPosition[    115453,       2188]
NotebookOutlinePosition[    115790,       2203]
CellTagsIndexPosition[    115747,       2200]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"mf", " ", "=", " ", "mtop"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mW", " ", "=", " ", "80.38"}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mZ", " ", "=", " ", "91.19"}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GF", " ", "=", " ", 
   RowBox[{"1.167", "*", 
    RowBox[{"10", "^", 
     RowBox[{"(", 
      RowBox[{"-", "5"}], ")"}]}]}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"me", " ", "=", " ", 
   RowBox[{"0.511", "*", 
    RowBox[{"10", "^", 
     RowBox[{"(", 
      RowBox[{"-", "3"}], ")"}]}]}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mmu", " ", "=", " ", "0.101"}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mtau", " ", "=", " ", "1.776"}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mb", " ", "=", " ", "4.2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mtop", " ", "=", " ", "173"}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Cc", " ", "=", " ", "3"}], ";"}]}], "Input",
 CellChangeTimes->{{3.543818596189143*^9, 3.5438186152679777`*^9}, {
   3.543818670898944*^9, 3.5438187153781013`*^9}, {3.543818752593528*^9, 
   3.543818769441517*^9}, {3.543818841216052*^9, 3.543818995770445*^9}, {
   3.543819376196701*^9, 3.543819377380517*^9}, {3.5438194338240557`*^9, 
   3.543819455427878*^9}, {3.543819655502783*^9, 3.543819665757388*^9}, {
   3.543819909943725*^9, 3.5438199144677563`*^9}, 3.543819968071561*^9, {
   3.543820918555036*^9, 3.543820930029389*^9}, {3.54382101751655*^9, 
   3.5438210180112953`*^9}, {3.54390413545522*^9, 3.543904136958452*^9}, {
   3.543904293419186*^9, 3.543904294042441*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Ghbb", "[", "mH_", "]"}], " ", ":=", " ", 
  RowBox[{"Cc", "*", "GF", "*", 
   RowBox[{"mb", "^", "2"}], "*", 
   RowBox[{
    RowBox[{
     RowBox[{"mH", "/", "4"}], "/", 
     RowBox[{"Sqrt", "[", "2", "]"}]}], "/", "Pi"}], "*", 
   RowBox[{
    RowBox[{"(", " ", 
     RowBox[{"1", " ", "-", " ", 
      RowBox[{"4", "*", 
       RowBox[{
        RowBox[{"mb", "^", "2"}], "/", 
        RowBox[{"mH", "^", "2"}]}]}]}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"3", "/", "2"}], ")"}]}], "*", 
   RowBox[{"HeavisideTheta", "[", 
    RowBox[{"mH", "-", 
     RowBox[{"2", "*", "mb"}]}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ghtt", "[", "mH_", "]"}], " ", ":=", " ", 
  RowBox[{"Cc", "*", "GF", "*", 
   RowBox[{"mtop", "^", "2"}], "*", 
   RowBox[{
    RowBox[{
     RowBox[{"mH", "/", "4"}], "/", 
     RowBox[{"Sqrt", "[", "2", "]"}]}], "/", "Pi"}], "*", 
   RowBox[{
    RowBox[{"(", " ", 
     RowBox[{"1", " ", "-", " ", 
      RowBox[{"4", "*", 
       RowBox[{
        RowBox[{"mtop", "^", "2"}], "/", 
        RowBox[{"mH", "^", "2"}]}]}]}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"3", "/", "2"}], ")"}]}], "*", 
   RowBox[{"HeavisideTheta", "[", 
    RowBox[{"mH", "-", 
     RowBox[{"2", "*", "mtop"}]}], "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.5438183072967653`*^9, 3.543818360910493*^9}, {
   3.543819116603957*^9, 3.543819132413104*^9}, 3.5438191699312468`*^9, {
   3.5438192247936153`*^9, 3.543819225145252*^9}, {3.5438194160849237`*^9, 
   3.5438194162768307`*^9}, 3.543819458819562*^9, {3.543906080239407*^9, 
   3.543906158561781*^9}, {3.5439066393670607`*^9, 3.54390664762083*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GhWW", "[", "mH_", "]"}], " ", ":=", " ", 
  RowBox[{"GF", "*", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"mH", "^", "3"}], "/", "8"}], "/", 
     RowBox[{"Sqrt", "[", "2", "]"}]}], "/", "Pi"}], "*", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"4", "*", 
       RowBox[{
        RowBox[{"mW", "^", "2"}], "/", 
        RowBox[{"mH", "^", "2"}]}]}]}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "2"}], ")"}]}], "*", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"4", "*", 
      RowBox[{
       RowBox[{"mW", "^", "2"}], "/", 
       RowBox[{"mH", "^", "2"}]}]}], "+", 
     RowBox[{"12", "*", 
      RowBox[{
       RowBox[{"mW", "^", "4"}], "/", 
       RowBox[{"mH", "^", "4"}]}]}]}], ")"}], "*", 
   RowBox[{"HeavisideTheta", "[", 
    RowBox[{"mH", "-", 
     RowBox[{"2", "*", "mW"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.543818368818022*^9, 3.543818436909298*^9}, {
  3.543818473420573*^9, 3.543818496940304*^9}, {3.543819317031749*^9, 
  3.543819324647456*^9}, {3.543906154255569*^9, 3.543906163230899*^9}, {
  3.5439066497632437`*^9, 3.543906652770612*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GhZZ", "[", "mH_", "]"}], " ", ":=", " ", 
  RowBox[{"GF", "*", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"mH", "^", "3"}], "/", "16"}], "/", 
     RowBox[{"Sqrt", "[", "2", "]"}]}], "/", "Pi"}], "*", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"mW", "/", "mZ"}], ")"}], "^", "2"}], "*", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"4", "*", 
       RowBox[{
        RowBox[{"mZ", "^", "2"}], "/", 
        RowBox[{"mH", "^", "2"}]}]}]}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "2"}], ")"}]}], "*", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"4", "*", 
      RowBox[{
       RowBox[{"mZ", "^", "2"}], "/", 
       RowBox[{"mH", "^", "2"}]}]}], "+", 
     RowBox[{"12", "*", 
      RowBox[{
       RowBox[{"mZ", "^", "4"}], "/", 
       RowBox[{"mH", "^", "4"}]}]}]}], ")"}], "*", 
   RowBox[{"HeavisideTheta", "[", 
    RowBox[{"mH", "-", 
     RowBox[{"2", "*", "mZ"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.543818451821426*^9, 3.54381850241261*^9}, {
  3.543819022751647*^9, 3.543819030271399*^9}, {3.543819329384178*^9, 
  3.54381933379961*^9}, {3.543820063062299*^9, 3.5438200747574997`*^9}, {
  3.543820892241104*^9, 3.543820900865114*^9}, {3.543906155328546*^9, 
  3.54390617051157*^9}, {3.543906654643983*^9, 3.543906657139185*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Ghbb", "[", "mH", "]"}], ",", 
     RowBox[{"Ghtt", "[", "mH", "]"}], ",", 
     RowBox[{"GhWW", "[", "mH", "]"}], ",", 
     RowBox[{"GhZZ", "[", "mH", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"mH", ",", "100", ",", "450"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Magenta", ",", "Red", ",", "Green", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.543819038606275*^9, 3.5438190582335176`*^9}, {
  3.5438191846631002`*^9, 3.543819186710752*^9}, {3.5438193412992992`*^9, 
  3.543819341810588*^9}, {3.543819478335785*^9, 3.54381947943924*^9}, {
  3.543819594492975*^9, 3.54381962918116*^9}, {3.543819738380636*^9, 
  3.5438197708750134`*^9}, {3.54381988322514*^9, 3.543819893592848*^9}, {
  3.5438285440640593`*^9, 3.543828569486747*^9}, {3.543828905383699*^9, 
  3.543828910806588*^9}, {3.543829462105083*^9, 3.5438294640722313`*^9}, {
  3.543834972511155*^9, 3.5438349726383553`*^9}, {3.543904284076095*^9, 
  3.543904288635132*^9}, {3.543906180428514*^9, 3.543906209947796*^9}, {
  3.5439065368363113`*^9, 3.5439065390915737`*^9}, {3.543906577363481*^9, 
  3.543906580386601*^9}, {3.543906823485285*^9, 3.5439068245244627`*^9}, {
  3.5439069669536533`*^9, 3.5439069681045647`*^9}, {3.543907075175308*^9, 
  3.543907079958313*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[1, 0, 1], LineBox[CompressedData["
1:eJwBgQF+/iFib1JlAgAAABcAAAACAAAAIq3EvbFrEkBo0+0v57AWwI5J36oq
bBJA88osr2uwFsD55fmXo2wSQH2XCC/wrxbA0B4vcpVtEkBhGZYw+a4WwH6Q
mSZ5bxJARKcEOwutFsDac26PQHMSQCdAD20vqRbAkToYYc96EkBj5dZEeKEW
wADIawTtiRJAtjYxuwuSFsB9ln9Hs6oSQBzXyz2icBbA64ZpiE3JEkC9rGPI
eFEWwIN0BhxO5xJA1JXr7PMyFsC6FRCs2QcTQIJrTGrhERbA4tjvOTkmE0Do
sR53C/MVwKhPPMQjRxNAyXY4V6jRFcCZwzuhdGcTQO7MkW7osBXAe1kRfJmF
E0ClJukmYpIVwPuiU1NJphNAZIIZ+k5xFcBsDmwozcQTQPcN2/tzUhXACHc3
ULfiE0CnzeVLOTQVwEKTb3QsAxRAbjer9HETFcBt0X2WdSEUQNx+sbLg9BTA
N8P4tElCFEAxrVEVw9MUwJCKPt9WURRARmf6xJXEFMCAHKf3
      "]], 
     LineBox[{{5.09620723353559, -5.175067685604972}, {
      5.125559168562873, -5.14548916168918}, {
      5.157394418232702, -5.113422768559746}, {
      5.1871086639835156`, -5.083505691412442}, {
      5.20561280598869, -5.064881208706646}}], LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAGwiWz5HgFEDjXAb4UzQUwFmf/Ifw
ABVAk6O8YMMTFMCHWDk+Ix8VQE8CwOdk9RPAVMXi8OA/FUDaeQqYetQTwBJU
YqFyXhVA4rq4wMG1E8D635SkanwVQK5YiJCllxPAgR80pO2cFUBrOW+l/XYT
wPmAqaFEuxVACLzjQYZYE8APloubJtwVQN+2dUWDNxPAUKgg6G78FUBLiMmQ
HBcTwILcizKLGhZASVDLl+X4EsBSxGN5MjsWQD2rNBoj2BLAE84Rvq1ZFkCX
aY3zj7kSwP7UclWPdxZAVUcRSpibEsCIj0Dp+5cWQPg6bS0VexLAA2zkejy2
FkAOHFHVwFwSwB389AgI1xZAMlIUH+E7EsAnrtuUp/UWQGHXbOIvHRLAXF11
c60TF0D04V+rGf8RwDDAe04+NBdAX9qqInjeEcD0RFgno1IXQIvEvaYEwBHA
Q70eHkNiF0BKQJV+XbARwFEGnu4=
      "]], LineBox[CompressedData["
1:eJwB8QEO/iFib1JlAgAAAB4AAAACAAAAV32h/JJzF0Dg83XoBZ8RwOWynSTp
kxdAgnSeBKJ+EcBjCnBKE7IXQFnEctFrYBHAgBWvbMjSF0Cvxv9kqj8RwI1C
xIxR8RdAwhuyexYhEcDFbIz/QA8YQPTKSBEdAxHAnErBbrsvGEDdYGR1mOIQ
wGNKzNsJThhAHfV+GkHEEMAWjrkukU4YQGo646C5wxDAytGmgRhPGECauFEn
MsMQwDJZgScnUBhA1VRNNCPCEMAAaDZzRFIYQD/Bvk4FwBDAnoWgCn9WGEBA
EIiFybsQwNrAdDn0XhhAYt+h+lGzEMCOBGKMe18YQHoSSILKshDAQkhP3wJg
GEBbKfgJQ7IQwKnPKYURYRhAAvh1GTSxEMB43t7QLmMYQNnP5zgWrxDAFvxI
aGlnGECuI6J52qoQwMo/NrvwZxhAFFvlAVOqEMB+gyMOeGgYQMBMMorLqRDA
5Qr+s4ZpGECiVOmavKgQwLQZs/+jaxhAu67LvJ6mEMBoXaBSK2wYQHhwXEUX
phDAG6GNpbJsGED81/bNj6UQwIIoaEvBbRhAJ45I34CkEMA2bFWeSG4YQLTX
/2f5oxDA6q9C8c9uGEDYvMDwcaMQwJ7zL0RXbxhACjuLeeqiEMBRNx2X3m8Y
QMFPXwJjohDAGxTYtg==
      "]]}, 
    {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJwV03s4lHkbB3BZZpGSU7+nA1PxiraMyKHs2+8mlZwGr4jahNKoQXKOEEIn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      "]]}, 
    {RGBColor[0, 1, 0], LineBox[CompressedData["
1:eJwV03lQ1HUUAPDlJkkJ+mpSjoAjDHEJxdEQ0tckQ2Ydh/uQQ3CV0+UOCBRI
AjTlEmUX5AjYiTvApGRY3g9cASskiFOGcNHlXmJh2V2Wq29/vHnz+ePNvHmH
fnCU61VFGo12lsT/2Y9bpjvpgnB0TVsfSkCURPEPpTliJs/Do7dHi2rtyBNe
c0XYdF+Q8ZSmQUXGuo/PEwunnW4UJalTRsY63aFuCCsURiLVVVXqLX+6fpF4
w0Z23HNIhapkVxWFuyN8yK+r0nddmfJzCbm5TDzWEt8ptlOmjr5jGhrpQfyu
KEevQokaodZchMQWQfO1pR8oUflJTz5neiKctPLPVmOFIkW3+NbgX2JdI6PE
w1aKlPqCg2a0F8K2ilzvjGEFilehtLVGLJxxE9gkK1BpXv2zMd4I+3gyvxcY
KlB2mvf+XCfO6Rsay3pFoyS9Lu1xPgj7Wod7O9+nUUybqdsJvghrBtqyftGi
UcarFXES4vv+2Y+4jfswx2H4J15C+PFfTy/R7ffB//CqRbIfwjby7nxOxB4c
HWj7UE7MzTazuX5gD0YyE5VT/BEeSbPvCWraBbqYNpEagHCJUxY/Zm8H1Buf
d+8SH2hLzZQ27ADvyp2Gm4GkftvoYIrfDtj//X5a+mWEc/XHraqfb4NJm6Fh
ZjDCmaZr/nWP5cDsmQ3cId7IhUnvJDm0DZez468g3PxFTWyegxzsNo4cvMog
/WcJ+HhwC5ys1MRfXUOYLyqrGdiXwV3HZ2ZdxK7JWh/1vJTBoHtaiE0Iwuaf
VOpyy2XgmSB9ZRiK8EUfSTH7jAwY7fPdauEI09suJI4WSKG2t3o7jZg9kd7J
D5HC8ligtYxY28fkZL2DFGKl47ULEQi31ymWuq1KIOOz/rwX1xEeP9e45Osh
gfKOWv8fYhD+em8pu+P0Jsz+zihWikVY50bir0vHNsFgSm8ohTgtxLc5Z0cM
jdssx8g4hHs3AzwUuGLosL9tciGB3MOJsOCiL8Uw3hW2dSiZ7JPBStcO2ID3
nhk/KExHeLRy97X+CxGcyJqQowyETaJyVaifRWB1PutyMXFflcoW66EIvAf5
Jo++Q9iNfs5cwhBB5RSrh5OJcIHVLTN7ZRFYilXXfstB+BjPy1KVvgauBm+c
Z/IRnmasjMjFQmAs5LcEFSDsbH9vR29ACN80OBx5Sxw11xyfxRFCiWUJf6EQ
4TrvsuMaXkKYPe2StF6EMOTsnZrpXIE4T+CosBFW0nj44E3hMhRll9JMf0T4
J1X31NfBi2Bejds5xGrLrbJbZxehv0sQoVuF8KQj6+L5k4uwvXlqXLuazE+r
aNh2bgGCGbymrRrSj9pAOitiASzPCH37asn+mjgKWqnz8FLu8CS4BWHjsHqd
hFYBqDNnw9hA/t1afZgbMAvT0aMf3x1GuOZTXj/HfBr+A7YbFf0=
      "]], 
     LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAGwiWz5HgFEBNmwTXuvbXv1mf/Ifw
ABVA9+Cm8JmDyb+HWDk+Ix8VQE0t5PGdNKi/VMXi8OA/FUBO6DGipwS8PxJU
YqFyXhVAImzcUIQF0D/635SkanwVQGVL4utqndg/gR80pO2cFUDzp1VTr9vg
P/mAqaFEuxVA5HOie38E5T8PloubJtwVQMoOiN9Xcek/UKgg6G78FUCSUJ2a
MbbtP4LcizKLGhZA4Hrh+tLQ8D9SxGN5MjsWQLrc8zbV6PI/E84Rvq1ZFkDE
9TFAA9b0P/7UclWPdxZAynsn5xaz9j+Ij0Dp+5cWQP7Qa6vxsfg/A2zkejy2
FkDsHSXBd4j6Px389AgI1xZASBT8MTCA/D8nrtuUp/UWQEa7bAbbUP4/XF11
c60TF0BfB6adqQkAQDDAe04+NBdAP5UB10L7AED0RFgno1IXQPumTHlS2gFA
Q70eHkNiF0A5izu4HkwCQNRlqEg=
      "]], LineBox[CompressedData["
1:eJwB8QEO/iFib1JlAgAAAB4AAAACAAAAV32h/JJzF0AFdCZvickCQOWynSTp
kxdAMgSv5/uxA0BjCnBKE7IXQAjwu+fHiARAgBWvbMjSF0BdKnaxlG8FQI1C
xIxR8RdAR6do2S5FBkDFbIz/QA8YQCUO8eDsFAdAnErBbrsvGECRyIkujvQH
QGNKzNsJThhAyhEFTqvDCEAWjrkukU4YQAKbg9BExwhAytGmgRhPGEBk4qM2
3soIQDJZgScnUBhA9M/lrRDSCEAAaDZzRFIYQLTQM0l04AhAnoWgCn9WGEC+
0Rg5Nv0IQNrAdDn0XhhACJC7LqU2CUCOBGKMe18YQIsx9zI7OglAQkhP3wJg
GEAS2rIb0T0JQKnPKYURYRhAbqXFmvxECUB43t7QLmMYQCWXGFBSUwlAFvxI
aGlnGEBxl2qd+G8JQMo/NrvwZxhAW3XZ7IxzCUB+gyMOeGgYQHhDNSEhdwlA
5Qr+s4ZpGEDLts44SX4JQLQZs/+jaxhAONVFJJiMCUBoXaBSK2wYQEYa2Zsr
kAlAG6GNpbJsGEBGNo/4vpMJQIIoaEvBbRhAn8p+YeWaCUA2bFWeSG4YQAKr
xW14nglA6q9C8c9uGEBvMkpfC6IJQJ7zL0RXbxhAPRETNp6lCUBRNx2X3m8Y
QEn2JvIwqQlAeKjCTg==
      "]]}, 
    {RGBColor[0, 0, 1], LineBox[CompressedData["
1:eJwV0Xs01HkYx/Ex4zKlzeL3m+nm3iYqUqKi5qmmQyYUinIrYkttWlaJUqtx
2UaUnMnKRrHEpmw2bW7fryhpXdp1rSmjSYkYTEbDzI797R/P+ZzXn+/zmIVE
eoXRaTSaP3X/72igeFS3gwB2Fa9I22sB5utv/7CS8iOdAS6+aYBHxKKmcso7
+OKUeQw97HM3qsS+kwBDyR4Gv2werjkzR/An5QePlpd/WKeLl/Lyjzl3EXCT
dyPb2GIuTlvo6IEpu1V9U7DebQ6WD7bacrsJMLBDIWNCJg6qPKT/jHKaospd
X62Dn/KVMl4PAQWZHo1NsTrYxjuzs51yondmqpCug4VmVpXevQRw6f3Zodna
WD2GrvVQJs0sFDJHbRxet/e0/0sCot4ND+eItXBb2uh+MWVR94yaTNfCjv58
59BXVI/O9Y6wrVo432qx8SDl2dL+VqTUxEzF77MRIqpnNnzs3CNN3Jslfhz1
moDs8ehpG9DEEHqycIpyipEBsYupiUvsvkqOe0NAhJb55rUdDBzXtnFHYh8B
9+zZyetPMLAk929rbTEBQ/ap/SNbGNjt6OF5FylruBi38UkGXswUtl/pJ2CF
cprXVE/HsbdOuRm+JSCrd0Pv+xw67nTe9ySLsjz8YI9vDB2nf7+k+pqEgC+l
Jd6iVXRMF90q+mWA6tW7u2fvbxo4OIZvZvKegKWhWv6f0zRwjV54bj7lXH/N
owGRGvgk1yqz4AMBedXesd86aODhsntnSz4S8FDXrziohYZdXK8orIcIaCs6
EexVQcOFkqjoO5T5XJ68NYeGg9gOR+4NE9DyYclH7lEa/ud8jc+DEQIiz80P
y9On4Srv5hX14wQwJX5nqvrViC0tLdo6QYDLcfVa12o1+iE1zayRsq9BQU64
UI1saj3ZTTICzHcPXNjqoUa3lnXTWycJeDPXyFfd8C+6OC152asgoNvSq9yv
UYUGrzb67J+m/peSvsmoSIW4NkXtIsqr8gO0nVJVSB1y5EnfDAHadzZJY91V
KKplrHxARUBrcPWhepES7ctTpYzTSKiK0PJ9o6VEmzO7vI5okPDUE3YrR2eQ
edJdIwnlVdEL6t27Z9BIxIGKDjoJKTS9+4LiGZTg0NhXqUlCgXV1hOfOGVTY
Klh3lkmCS8wfn6xuTKNx5aJ3c74mQU4U358IVKAu6eeyRMqjlYU5NJ4CVb1t
iVVS/k5mV7xyvQJdaEqYP6pPgiTYyPuVgQKxrko2vDAkofbIjUvnmr8gZ+vS
y0I2CT9f/XWZ0OkLSvHbsNnChASwV5Ynrp5CG9WMdUWUj9k8X2FmMoWkBW0r
rExJeGHaod/11RTyGQtdaGtGAiNIOhj/SY5Mk9MnN1qQIAoYF9QWy1FVxbtS
L0sSZrjM5g4LOZLOT2cn2pJwjxmrLFg+iXyeSMb7OSQUxV/Kz9gvQxkNhY7+
QELybHx0nbsMPa8PT+iiTIw8bJCDDEHdsO7zLSRc7uYln7WUoZUPZcsqtpFw
ULyWNzY5gTRL6IFJLiSMeLqfcLsygSrSzJutPEngKH9qOtA+jgx8Qm5GBZHw
qiQyPqlaimbEWYURZ0jYtH90x/24IfSjiX3haC4JDjYtgpN2A2j6fMlNbjUJ
qem1fa5MMdITCq4ve02Cyl6a99i1C+26bfrxuIqEJE/vzOOaz1Dia8EawSIW
9Cw/vbMl6Q7yagw9vcaJBRFnnZic6w84hm36dWX7WKCITE8fcvqLo+6M2pNx
igV5juMODhe7OKkZMKS8xgKP7SeGM2l9HMaxgTjnShaECRaZPnsn4RipJpnM
HhY0uFV2HNYd5FjeFWUVy1nA5Zaoa/qGOQGBMdFlhmyYuq0nTMiUclbjeI/N
9mxosLP2LeZOcCa5fpYFXmwI2jQ2xVvwmbOt1th4WwgbbFWeqgztSc5/Z+XF
KQ==
      "]], LineBox[CompressedData["
1:eJwB8QEO/iFib1JlAgAAAB4AAAACAAAAV32h/JJzF0BhVyGa6Qz1P+WynSTp
kxdAG4Njgnny9j9jCnBKE7IXQJSdqD5isvg/gBWvbMjSF0AAPv1y05L6P41C
xIxR8RdAxCR7CrNO/D/FbIz/QA8YQPp0ZmWx/f0/nErBbrsvGEA8QHBE4sz/
P2NKzNsJThhALw9O1ZW8AEAWjrkukU4YQAZyn99NwABAytGmgRhPGEClnCfG
BcQAQDJZgScnUBhAAUf+J3XLAEAAaDZzRFIYQIGLsj9S2gBAnoWgCn9WGEAM
qp7GBfgAQNrAdDn0XhhAQYxzbVIzAUCOBGKMe18YQDz09w4GNwFAQkhP3wJg
GECdJ8CNuToBQKnPKYURYRhAOCo9IyBCAUB43t7QLmMYQJjc0a7rUAFAFvxI
aGlnGECy16JPfG4BQMo/NrvwZxhAfYlFyS1yAUB+gyMOeGgYQAY7sCDfdQFA
5Qr+s4ZpGEB5dP5oQX0BQLQZs/+jaxhAa81jYASMAUBoXaBSK2wYQDEULMm0
jwFAG6GNpbJsGEAW4f0PZZMBQIIoaEvBbRhAR7PeN8WaAUA2bFWeSG4YQLIH
/hh1ngFA6q9C8c9uGEB+gEfYJKIBQJ7zL0RXbxhAYEHDddSlAUBRNx2X3m8Y
QH5sefGDqQFA8AzGVw==
      "]]}, {}}, {{}, {}, {}, {}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->NCache[{
     Log[100], -12.374479355537899`}, {
    4.605170185988092, -12.374479355537899`}],
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& )},
  FrameTicks->{{{{-11.512925464970229`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-9.210340371976182, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-6.907755278982137, 
       FormBox["0.001`", TraditionalForm]}, {-4.605170185988091, 
       FormBox["0.01`", TraditionalForm]}, {-2.3025850929940455`, 
       FormBox["0.1`", TraditionalForm]}, {0., 
       FormBox["1", TraditionalForm]}, {2.302585092994046, 
       FormBox["10", TraditionalForm]}, {-10.819778284410283`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.414313176302118`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.126631103850338`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.903487552536127, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.721165995742174, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.567015315914915, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.433483923290392, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.315700887634009, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-8.517193191416238, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-8.111728083308073, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.824046010856292, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.600902459542082, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.418580902748127, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.264430222920869, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.1308988302963465`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.013115794639964, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-6.214608098422191, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.809142990314028, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.521460917862246, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.298317366548036, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.115995809754082, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.961845129926823, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.8283137373023015`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.710530701645918, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.912023005428146, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.506557897319982, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.2188758248682006`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.995732273553991, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.8134107167600364`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.659260036932778, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.5257286443082556`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.407945608651872, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.6094379124341003`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.203972804325936, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.916290731874155, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.6931471805599453, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.5108256237659905, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.35667494393873245`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2231435513142097, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.10536051565782616`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.6931471805599453, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.0986122886681098`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6094379124341003`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.791759469228055, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9459101490553132`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{-11.512925464970229`, 
       FormBox["\"\"", TraditionalForm]}, {-9.210340371976182, 
       FormBox["\"\"", TraditionalForm]}, {-6.907755278982137, 
       FormBox["\"\"", TraditionalForm]}, {-4.605170185988091, 
       FormBox["\"\"", TraditionalForm]}, {-2.3025850929940455`, 
       FormBox["\"\"", TraditionalForm]}, {0., 
       FormBox["\"\"", TraditionalForm]}, {2.302585092994046, 
       FormBox["\"\"", TraditionalForm]}, {-10.819778284410283`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.414313176302118`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.126631103850338`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.903487552536127, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.721165995742174, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.567015315914915, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.433483923290392, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.315700887634009, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-8.517193191416238, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-8.111728083308073, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.824046010856292, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.600902459542082, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.418580902748127, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.264430222920869, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.1308988302963465`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.013115794639964, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-6.214608098422191, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.809142990314028, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.521460917862246, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.298317366548036, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.115995809754082, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.961845129926823, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.8283137373023015`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.710530701645918, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.912023005428146, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.506557897319982, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.2188758248682006`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.995732273553991, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.8134107167600364`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.659260036932778, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.5257286443082556`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.407945608651872, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.6094379124341003`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.203972804325936, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.916290731874155, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.6931471805599453, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.5108256237659905, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.35667494393873245`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2231435513142097, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.10536051565782616`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.6931471805599453, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.0986122886681098`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6094379124341003`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.791759469228055, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9459101490553132`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}, {{{4.605170185988092, 
       FormBox["100", TraditionalForm]}, {6.907755278982137, 
       FormBox["1000", TraditionalForm]}, {6.214608098422191, 
       FormBox["500", TraditionalForm]}, {8.517193191416238, 
       FormBox["5000", TraditionalForm]}, {5.298317366548036, 
       FormBox["200", TraditionalForm]}, {7.600902459542082, 
       FormBox["2000", TraditionalForm]}, {5.703782474656201, 
       FormBox["300", TraditionalForm]}, {8.006367567650246, 
       FormBox["3000", TraditionalForm]}, {5.0106352940962555`, 
       FormBox["150", TraditionalForm]}, {7.313220387090301, 
       FormBox["1500", TraditionalForm]}, {6.551080335043404, 
       FormBox["700", TraditionalForm]}, {8.85366542803745, 
       FormBox["7000", TraditionalForm]}, {4.700480365792417, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.787491742782046, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.867534450455582, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.941642422609304, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.075173815233827, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.135798437050262, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.19295685089021, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.247024072160486, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.991464547107982, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.396929655216146, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.684611727667927, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.802394763324311, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.003065458786462, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.090076835776092, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.170119543449628, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.24422751560335, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.3777589082278725`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.438383530044307, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.495541943884256, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.549609165154532, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.294049640102028, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.699514748210191, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{4.605170185988092, 
       FormBox["\"\"", TraditionalForm]}, {6.907755278982137, 
       FormBox["\"\"", TraditionalForm]}, {6.214608098422191, 
       FormBox["\"\"", TraditionalForm]}, {8.517193191416238, 
       FormBox["\"\"", TraditionalForm]}, {5.298317366548036, 
       FormBox["\"\"", TraditionalForm]}, {7.600902459542082, 
       FormBox["\"\"", TraditionalForm]}, {5.703782474656201, 
       FormBox["\"\"", TraditionalForm]}, {8.006367567650246, 
       FormBox["\"\"", TraditionalForm]}, {5.0106352940962555`, 
       FormBox["\"\"", TraditionalForm]}, {7.313220387090301, 
       FormBox["\"\"", TraditionalForm]}, {6.551080335043404, 
       FormBox["\"\"", TraditionalForm]}, {8.85366542803745, 
       FormBox["\"\"", TraditionalForm]}, {4.700480365792417, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.787491742782046, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.867534450455582, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.941642422609304, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.075173815233827, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.135798437050262, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.19295685089021, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.247024072160486, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.991464547107982, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.396929655216146, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.684611727667927, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.802394763324311, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.003065458786462, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.090076835776092, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.170119543449628, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.24422751560335, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.3777589082278725`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.438383530044307, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.495541943884256, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.549609165154532, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.294049640102028, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.699514748210191, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  ImageSize->{696., Automatic},
  Method->{},
  PlotRange->NCache[{{
      Log[100], 
      Log[450]}, {-12.374479355537899`, 3.2076128881588244`}}, {{
    4.605170185988092, 6.1092475827643655`}, {-12.374479355537899`, 
    3.2076128881588244`}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{{{4.605170185988092, 
      FormBox["100", TraditionalForm]}, {6.907755278982137, 
      FormBox["1000", TraditionalForm]}, {6.214608098422191, 
      FormBox["500", TraditionalForm]}, {8.517193191416238, 
      FormBox["5000", TraditionalForm]}, {5.298317366548036, 
      FormBox["200", TraditionalForm]}, {7.600902459542082, 
      FormBox["2000", TraditionalForm]}, {5.703782474656201, 
      FormBox["300", TraditionalForm]}, {8.006367567650246, 
      FormBox["3000", TraditionalForm]}, {5.0106352940962555`, 
      FormBox["150", TraditionalForm]}, {7.313220387090301, 
      FormBox["1500", TraditionalForm]}, {6.551080335043404, 
      FormBox["700", TraditionalForm]}, {8.85366542803745, 
      FormBox["7000", TraditionalForm]}, {4.700480365792417, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.787491742782046, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.867534450455582, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.941642422609304, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {5.075173815233827, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {5.135798437050262, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {5.19295685089021, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {5.247024072160486, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {5.991464547107982, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {6.396929655216146, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {6.684611727667927, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {6.802394763324311, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {7.003065458786462, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {7.090076835776092, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {7.170119543449628, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {7.24422751560335, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {7.3777589082278725`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {7.438383530044307, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {7.495541943884256, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {7.549609165154532, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {8.294049640102028, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {8.699514748210191, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}, {{-11.512925464970229`, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-9.210340371976182, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-6.907755278982137, 
      FormBox["0.001`", TraditionalForm]}, {-4.605170185988091, 
      FormBox["0.01`", TraditionalForm]}, {-2.3025850929940455`, 
      FormBox["0.1`", TraditionalForm]}, {0., 
      FormBox["1", TraditionalForm]}, {2.302585092994046, 
      FormBox["10", TraditionalForm]}, {-10.819778284410283`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-10.414313176302118`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-10.126631103850338`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.903487552536127, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.721165995742174, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.567015315914915, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.433483923290392, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.315700887634009, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-8.517193191416238, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-8.111728083308073, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-7.824046010856292, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-7.600902459542082, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-7.418580902748127, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-7.264430222920869, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-7.1308988302963465`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-7.013115794639964, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-6.214608098422191, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-5.809142990314028, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-5.521460917862246, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-5.298317366548036, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-5.115995809754082, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-4.961845129926823, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-4.8283137373023015`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-4.710530701645918, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-3.912023005428146, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-3.506557897319982, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-3.2188758248682006`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.995732273553991, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.8134107167600364`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.659260036932778, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.5257286443082556`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.407945608651872, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.6094379124341003`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.203972804325936, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.916290731874155, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.6931471805599453, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.5108256237659905, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.35667494393873245`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.2231435513142097, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.10536051565782616`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.6931471805599453, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.0986122886681098`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.3862943611198906`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.6094379124341003`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.791759469228055, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.9459101490553132`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.0794415416798357`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.1972245773362196`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}}]], "Output",
 CellChangeTimes->{{3.543819336776978*^9, 3.543819342427856*^9}, 
   3.543819380470758*^9, 3.543819424089747*^9, {3.543819466619383*^9, 
   3.543819480120811*^9}, {3.543819596472785*^9, 3.543819629721232*^9}, 
   3.543819671848373*^9, {3.543819759516964*^9, 3.543819771397724*^9}, {
   3.543819883731142*^9, 3.543819919442212*^9}, 3.543819972378738*^9, 
   3.543820078322384*^9, {3.5438208747619677`*^9, 3.5438209048130713`*^9}, 
   3.54382093845037*^9, {3.543821014470833*^9, 3.543821022950437*^9}, {
   3.54382855368997*^9, 3.5438285699457808`*^9}, {3.543828906308765*^9, 
   3.543828911862123*^9}, 3.543829465187072*^9, 3.543834973301877*^9, 
   3.54390414312988*^9, {3.5439042894781847`*^9, 3.543904298950038*^9}, {
   3.543906173415474*^9, 3.543906210710429*^9}, 3.543906539750766*^9, 
   3.543906580993712*^9, 3.543906663618114*^9, 3.5439068251594753`*^9, 
   3.543906968785956*^9, 3.5439070806624537`*^9, 3.545386846653535*^9, 
   3.5453926107911997`*^9, 3.5454714489740868`*^9}]
}, Closed]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ghtot", "[", "mH_", "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"Ghbb", "[", "mH", "]"}], " ", "+", " ", 
   RowBox[{"Ghtt", "[", "mH", "]"}], " ", "+", " ", 
   RowBox[{"GhWW", "[", "mH", "]"}], " ", "+", " ", 
   RowBox[{"GhZZ", "[", "mH", "]"}], "  "}]}]], "Input",
 CellChangeTimes->{{3.543906219507435*^9, 3.543906259160425*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Ghtot", "[", "mH", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mH", ",", "100", ",", "160"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.54390626329941*^9, 3.543906290662283*^9}, {
  3.545471464293762*^9, 3.545471570487823*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVzns41XccB/ATCjvbGOXQklsKXVyKmujzKU/yDJUTrR/O9fuk0TnO/ddV
I12cXFIunVrLydKim8Vm1amNdqyTkpoytGqkZ6FISC7Hzv74PO/n9Xyez/v5
uAkl7M1mDAYj2jT/p7/BfSqDQWGF1RLuHR8RHDrC2rdwCoUPY55EeS4QQQf1
sXmCGYWl/QuXpy8UQWH3EONnCwqf8O45BPmJYJhpGN9qTWHyJqPhdKAIdGsl
gy12FKZHLHbdgSKIaL7eedmTwlZhaM68jSLgP4ut40VSWO4l3pyZIQKXYM9c
h+8oTGmSDmQ8E8FoYyCLvKIwxHUsD5eK4dZw2U6/JfGom7C/sjJXDJ+T6p7Y
/fFYbPa++mC3GPKtzWfZPIjHU25rVYdXpkLhYB/l6pGAtfryve0lqXBAHiK7
okjA9KHJlJRx097HsKbtZgLeCzDT6NgSCJg3OJ+yTUT/8C/S2JUS6OXw7osT
EzFCrAl6bC6Fwnk+UeY/JCIjSicsWySFu4EFj/veJ2Lw7edzHThScN0T4ioP
46Bvm+ZwcpYULJj7tkUWcbBF5h7HrZHCI5/558q6OHji4ppkVZcUbu2z0xT5
cXFZnKRaYisD9NAUPcngoq7LyoUJMmgb47Cv3uOivnwa81CKDMyd6ma9duFh
xxtZR/lxGcw07P/ttJSH7q11st4/ZBBdpfbovc7DyAKctHsnA8u3M+7UT+Nj
aUXNyjY3OWzztBR2LOCj9kx77f5oOXA9ziWtYPPRPjhwR+x2OeSEOQ7od/Jx
w4zcqltn5WBI9+JotHx816kuYD2UQ/Rzy3XFBj5mhtxuYE5RQIT1sYvNb039
seIID18FxKyr7+GwBGhup21wiVdAac3vlXYowL7ikzt0WQqYEkri7JIECE+P
8FZUK6Al+8ckdrYAvcfGejufKmBovNF4o0qAmrmcXd6fKMEtO4dWtgowL0he
ELtMCUXLnVQbzYQY58ZQu2xRAss6fEOmlxDrAzYvbjqqBFut+6n+aCGGWby4
duaGEmKoRomaFmK/b9ioY68StL4z3cQnhag/4BmkYKlgqVcgtVsvxJHO6R+J
w1WwuntyouG1EBteNNceUqpAYEjZm2RPsNX92NW8EhXo75zJXRBCsNO6a25A
o+n+1Z7toUKCn92tGb7+QQWuD6ya8g4S9DJm9CXPoWF9u+ASs5Jg1oOx0Bo2
DYfNEkR/PiI4sK7BqyeNhoH1JbN3PyY4VTdic2EPDRtLOpvmtBBcutvxvegb
GmaFiALpvwjyjYv0b9JpqFClGR3bTf/4/sIfyKRB/29JPvc5wRN0SNEHNQ1j
jS+qX3UTTLJwGLQspoHr7L3laA9B+dH81tsm120VOy3vJfhrycRN9TEasqyG
03JeE+SGXlYzj9PgsMpyjW8/Qb8K6WybkzT4/+TdqhwimKgUr3YopaHQPDXb
eZigU7GtT4vJIzFXQutN5kWd/VTzPQ033wSXskYI3t1V3uJURkOUV9TWa6ME
kWmT7HyOhko635mMEVw9HB791GR7ffN95jjBr9Nl/iXlNLQJOEs4EwS/3Hbq
g+t5GkIrT7+caiR4/qX2739M1hq7NJdMTh0tqi29QINFtE/kV5MEu6rSyshF
GrZ8mzoxaTJv+ib1nEs0/AfFlS+x
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{100., 0.0034000000000000002`},
  ImageSize->{747., Automatic},
  PlotRange->{{100, 160}, {0.0034383728503835824`, 0.005537169190124563}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.543906277139722*^9, 3.5439062911269417`*^9}, 
   3.543906669706758*^9, 3.545392622293969*^9, {3.545471467059513*^9, 
   3.545471571174718*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Ghtot", "[", "mH", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mH", ",", "100", ",", "200"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.54547151983792*^9, 3.545471520587638*^9}, {
  3.545471598035321*^9, 3.54547160594699*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVj31Q03UcgAfxpsBhiaBYAceKE0XjMF948fPBCEVoMDNyA2T7fX+eRhvb
GHzFE7PkJTw1yDFkgwmFTMUDOmZTMBE5RcIX4BBsBpSChgiyeSA4ArM/nnvu
+fPxZWTbd9tyOJzIN/zv7XGFThyOAI+e4TIdARIoetGd/9JGgDU8RusSKIFO
tbv9+FsCVMfVd/PWSCC2X2PzwFGAOsgK7wmWQNRXp60GNwHmW28t6A+TQGhO
49gebwFaGs5njvMkwL041NW5SYBE1FnmppTA1PsbNBUHBfhz35FA/mUJDIhU
2GUvxIO5h93NX0phaqddtjVXiAXrp1q9R6Xw/NOrvnqbRFxnGb/O7k+DldWr
Bh8VJKK8ied9zV0GpU31q5c5JmEB11tuqJbBts2P1X8XJiFHrffc5SuHgWZ2
zwqPZOwPeuKSliaHCsur21+rknF4UrEqxigHfUlENCzfhf2WTdxgOwX0W04J
XLS7EGZLdj6NVcBkRNQ9oUcKnjd/si2wWAHxdpW7Q3QpaJ/MazzwUAHS5u9v
HHEVYV8+91/NinToNZQONfNFeLZ7PKV1XzrUVt01XigW4fD8jvms6+mgS3Pb
4d8jwivDzt0cFyXUp5/LfuQhRs2oQ/oJgRJMfJ7MK0GM4ov8l1M/KeGD1Nhx
rVaMhng/K2NWwqNsmU//gBj3N1fwUsIz4GKq7j3tuwyWmYM0q/MyoO5Hrr5S
xGBQDuPl2JMBV1TGGb9KBgM8er0MyzMhvEjK2TvI4Flm36EJJhP+unFQNelL
sERUeH/tL5mg6Ss1z4kILsktP8ybyYRMH1dTXDVBe1P0kDyKQn5ejl+SnqDE
6ZChaguF0tFX0r1nCHZVFeX0baXQdOGJ7XfnCG78ONovLIbC/NaWVQ21BNeI
F4kd4ykUKJTfuhsJCu/O9uoEFMpbTf6mNoK+kWnVHRIKtf7x6Y9vElz6IFQx
J6XQfKztN0s7wdjCJ2EfySg8TDDwF94imCPt6VErKHz47NiB0E6CZSpnjphS
qF+Mnbr7BL0TrPzpQxRaWT1lRgg+n5z+009FAaciLyQ9JZjrf+l1RDGFK3lD
loRRgiMaoZ9ITeGS3kcaM0ZQFxeVWn6SQt2Ilqw1E2zJanzpXk6hTFIY7zBD
sLPwnYUO1RSWzgX+wHlFsPb3mZVcPYWS47dvWd+0qeDaZ5vPUDhRt2DLxCzB
nWetRd+ce/Nvzgn/4zXBvGFnj+laChkZWQE1jiy2L67zGjFSeGHnufe0E4tC
fXOIwyUKMvWv1acWsDho2yDkNlJINb7wUTmz2BIQoRVdpiCakXhmu7HoU2uz
1HSVwmCB8xd0EYuMw4r10y0UEpfVnJC/zeLJmOCEJa0UEkL+cd29mMWOGrOK
f53CvY68mBR3FjffqWqQ3aCwPZF7RLCERc3Yxu7jbRS6nrW2fe7BopOrYeL8
TQpjky4NsZ4srruz4Wh7O4X/AG71+vs=
      "]], LineBox[CompressedData["
1:eJxlVGk0FXgcRUqLtIwRWR5ZIkLZIvx+o5lJkiZ1SulNlr9/ZcTEO1mnqYlE
IpE3zJQcyfHkESJG9u2RelmSpfSWQvKUMZbyaszn+XDPPffLPfeee87V8Qly
95OTkZHZt4D/ONpZqndIjaDuxLvp5OQMaN7s8NB+PUGfDfnvBRuz4NvqgY/W
6gQtVh6PSw+8DfVuEdu2aBDcP7e4/aR5LsCQ6hljTYKTvIzRjht5UBVUXqKv
RfDOk/jE4Cf5YCdz8AODQVBr4LdpSVcBPLg6Zbpem+Da8ymuD0sLwUonJUBZ
h+B6h6ORNlVFYO7EH16qS/B8hJ7IglkM3M5A/UV6BIuf+1+JY5SAse9KX+mC
Zu6K/yLbXwIG0S4vPxgQ5O+tErTZ3YdL4SqOsoYEWUqv6nze34e3gcIbq40I
WvZ2Zq+4VQbcwxFMM2OCs1LlyvKJcrAx4wwGmBGsUnJVrfashAy9M/ZR5gSX
BNkz+sYrYV7N6c/LWwjOpMryX0b9BbXy/Z4cC4LWeSxmwLUqcO5fNjBsQ3DC
RKA1llkNnCc9djPbCDaZKn0Y0qwBxaasjCV2BOdGeQxBeg3wC22P6NsTVBKx
Xm/9vhYOx5zs80GCahtNRN2mdeBvzut94UwwZ1LehTlUD4/0r9uM71rYQ5o2
1rW2AUzVvdnzLgSzVRpHm79rgMnFcwfV9xCcT23M2cppgMgBw2ce+xb6qDme
jT/VCAkXL3V3HSbY32nt8PlVExQM7nzK8yfY4rUiSetyK0RJt+u1/EQwzb59
3WBRK7homYc2BhAcHqm7Q5+1wptjqpo1gQSTQvekvdHmgbZo5ERpMMHt+d1R
nBIepI7GyWRGELzG0Z6f4rdB1HS7GSt+Yf9w3xDziUewe/UPiVqchbyRiUf3
+vNBvklVrJJPMM9+frYvjA9V4QLbVXcJKsQf7z8SywcTUfDrLwUEDXoPDcBt
PiiWXbcX3CO4oq+kOf0FHx57DrzNriAYp+J8OtvtKbjn0p1GPIJsS+alu5s6
4YjjLzKWIwSd3P/BPx53weWcRZ+Tjf0wWfFKq41GL3QPpzYF+PuhsuJM+DfS
PgDfX1Wvcv0Qv9qUy/g0CPUVLCtziR/mUs9TrNIhKFuepJBsQvHAPOvCiLEA
HqXK+dn9TFExzU779e9C8E68JbU+TVGiYflg200hTMc6plkEU/y7o9E3IVsI
jMiIFhMWxcdy7BkLrhCCvSeNGGEUIz0PMKIbhKBqKpQsOkexMsfvuaFECL4t
dWEdSRTl67J0Y3eIYLb22Jq2qxQfZusov3QWQUKlNK85mSIzpdrAyk0EZQW2
AzUpFNe1yZeKPESwNPWeQzGboodXVoRToAi4Xlly7EyK07NdXyuki+Dj3LkE
r0KKg2PcHwslIgjxcN0ZXETRiZ1jfHZKBO/K1slF36OYFiMx2/NRBEMh3NDc
EoqaTidfjS0WQ+P4gI+knKJ3Q6zEWFMMDq65mjIVFBmQfmF+gxjKOMHP11RS
LGL37O8wFEPe8WVuVlUUL/YU5wZZiiFRYG0bVUsx2E53U/luMSig3NSVOooa
XsU5cfvEcO5mBzeznuIdWyOvo4fEEOJJ9BoaKeqE3U6R8xXDuwqzoe4muvBH
KSufnRADVf2U/qZ5wb/coTUvUAwePcmrlvMo5pmxZd0jxPDUgtmm3kbRatzk
vME5MbhcM4zZ3E4x9Jbrjk8x/9f/AgHGbrk=
      "]], LineBox[CompressedData["
1:eJwBYQOe/CFib1JlAgAAADUAAAACAAAAPU+/+lDNZkBc93QZTfDkP7atirVi
zmZAZvqPDtIa5T8wDFZwdM9mQBbnMfglPeU/qWohK4bQZkC/MbeRIVvlPyLJ
7OWX0WZAdaii4U525T+bJ7igqdJmQO3sugx7j+U/FIaDW7vTZkDK7AIHIafl
PwdDGtHe1WZA5JqzYATT5T/svEe8JdpmQGGZRSSbIeY/ZRsTdzfbZkC+rSpt
4zPmP9553jFJ3GZA7qiqbr5F5j/RNnWnbN5mQGqmsR9WaOY/trCikrPiZkBu
/e+84qnmPy8Pbk3F42ZAXhuos6W55j+obTkI1+RmQJC8D3wxyeY/myrQffrm
ZkDlze6LsefmP4Ck/WhB62ZAMFZ6z6Mi5z9KmFg/z/NmQPtavuQckuc/rYr4
/Nv0ZkCfa++7UJ/nPxB9mLro9WZA4zdLg22s5z/WYdg1AvhmQOmxA2dlxuc/
YitYLDX8ZkCRUjZTZPnnP3q+VxmbBGdAXo4FhSxc6D+q5FbzZhVnQB18zmf9
F+k/CzFVp/42Z0CQu3veiXbqP+SkXNmqdWdANar3XG3V7D/fUb2Wn7lnQH0J
HKAER+8/8tkoHhH5Z0B1y/AaIsHwP3VcuVpDN2hAoxpbi0TX8T8aGKMivnpo
QHbK4nWsBfM/166XtLW5aEDlC7Y2MSL0P30xtN3OumhAvi5+xS4n9D8jtNAG
6LtoQN0xRJosLPQ/b7kJWRq+aEDWizAXKTb0PwfEe/1+wmhA5RhDaCVK9D83
2V9GSMtoQKtIzLMrcvQ/lwMo2NrcaEAIRrxAccL0Pz2GRAH03WhAqHrKNXjH
9D/jCGEqDd9oQNN+VXt/zPQ/Lw6afD/haECrjxr5jtb0P8cYDCGk5WhA7Szb
x7Hq9D/3LfBpbe5oQJT6AvUGE/U/nbAMk4bvaEBG59kVExj1P0MzKbyf8GhA
l/vrix8d9T+POGIO0vJoQAix5ng5J/U/J0PUsjb3aEAq2ilecTv1P83F8NtP
+GhAr5rPMIBA9T9zSA0FafloQG5I81qPRfU/v01GV5v7aEAVftC2rk/1P2XQ
YoC0/GhAR2AX6b5U9T8LU3+pzf1oQC/l9nPPWfU/sdWb0ub+aEAFDbVX4F71
P1dYuPv//2hAqJOXlPFj9T/2V65A
      "]]}, {}}, {{}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{100., 0},
  PlotRange->{{100, 200}, {0., 1.3369003109339506`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.545471599346249*^9, 3.545471606463072*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Ghtot", "[", "mH", "]"}], ",", "mH"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"mH", ",", "100", ",", "1500"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAAfFbWdwAAWUAi0zDiyipsP+hDe197
G1lAx6lRoGlKbD9UMSBH9jZZQDUEXqgHamw/KwxqFuxtWUBP52GfQalsP9rB
/bTX21lA2IQWZ60nbT83LSXyrrdaQAHDji9mJG4/8gN0bF1vXEBUaiHKtA5w
P2mxEWG63l9AmbfLMAUHcj/Up60FhfxfQDrv8pEXGHI/H88k1ScNYEDDrSS/
KSlyP4rFwHnyKmBA4rvjf01Lcj9fsvjCh2ZgQEP4AqqSj3I/CoxoVbLdYECg
PBoUFBhzP18/SHoHzGFA3uU8gPYodD+UOpbM7NphQKJ2iVUDOnQ/yjXkHtLp
YUCgsHIFEEt0PzQsgMOcB2JAGoWM9ihtdD8KGbgMMkNiQBbRtSdZsXQ/tPIn
n1y6YkCXQvgQszl1P+rtdfFByWJAuj0Dub1KdT8f6cNDJ9hiQL1d8EDIW3U/
it9f6PH1YkCk4Z7x3H11P1/MlzGHMWNACsJa3gTCdT8KpgfEsahjQMea4iJP
SnY/LAGIYpq2Y0DvGzXwNlp2P09cCAGDxGNAvTxJpR5qdj+UEgk+VOBjQM5d
gcftiXY/tm2J3DzuY0BsfQk11Zl2P9nICXsl/GNAM38bi7ypdj/8I4oZDgpk
QG8a6MmjuXY/5gdiwKgVZEDuiQVk6MZ2P21s3ag=
      "]], LineBox[CompressedData["
1:eJwVkXk01AkAxzU0g3FfIQwzjnHl7iXt/L6V3rYRJtFKSaWGMY0xhyY83m6S
1cl2sHSIEjlqk1RiUSJtvVo5aieeLIOyaBxrsNv+8Xmf/z7/fGz2JWw7QFJR
UQn+yv9WKS0MCJIdRP5r/2vc8CGCTrIcXT12EIXhGTQT+jCxafelLNo/B/Ft
X3aZVucwEVtn6aBO4eDNDocSslROVPKtYnrpHJwPrvfLLB0h8vpZTqnuHBi4
bH943HuUyNi2Z8KKxUGZaQx57vEosXP11dSYCA56Sn9t6WobI8hLNuf/PsPB
MUXdQnf7ZyL6lF3r8kUOnJmrOnveTBCGFS5Mz+5YBPWoWJy5qSCWLLeOdw7G
wo/CuqscUhCjZw7VHJ6KxVKTbCDfbpr4TVSFx9pxMI0U3BAVTxM8P/eIzf5x
ONlbXfBH0QzR+twrO+pOHNhRo5T68jniyMjaT9knuBA+9VR1nlkgBvu6zob9
wkVTSdBIx8ZFIqhL6GNdxkVgoFdod84iYdtSnnavlYvvhf7ZHm5LxMtCc/3+
ZfHYKJGv0U74l7ANmffxkcbD40bUI13SMryqfZDeF8NDQ/J9Pu+JKtZWhtmW
i3jQjReXlk+poqR4sk38Iw+H1WxaHG3UkHzW0UDzKg9VbYqGsTQ12HLzS7zf
86BT4RmZ+c1yJFseaf+JfQgMRfrakGdk2GWsMfRm8SHWvXLhLx1NpL4jq5EC
+RDq6znob9BEp/tbxasIPly2LvSmSDSRIUvsipfw8V34y226Mk0Mrr6VX1zB
h2aAs6dXNRUlI5bWhisTEGMtHcrdow16sKrr1GwCXJWDUYNSPdS/kev0kwQY
tgq9+fMFPcgXgynPNAR4bXFUGVOjB2y3mju3QoAi2S51/oQeJlQe9bp7CRBp
Xly3kquPkJ2KwliuAIYWY4zp/QbQ1eYwenoEqBJdqjMXGiF5nkoN7RfgOL0i
XeOiEYaGb0/9PizAhFfBa3q9ERqa55taZgSYHR/mviUbgyc9HV1tlIgXVdTm
dZeN8fzjvUuZIYmouJ3Atn9rgmMP1Ux92hKxPKvYd3q/GSZKy/6tfpX49ZdT
/u7TZth1PmjYqTsRLEqo8Zc6M3gL8mqthxIxvkxw97qOOQbsXMK01ITgbSiu
ca43B3JCcz8SQmh7lDNe0Cyg5FzTyr0vhJmR2Sa5Bg0d0SvURxuEoPAIsq8v
DQURJ1U3tArBnE+9cj+WBr+ApPnJzq89/cBiVhsNKau2yNlTQozfjZt96G8N
pWKyRd9VhJQXmY2BmjZQ/rA+JeeaCK3qnhfNSunoSK5NGikTIcDqE/VOEx0F
Imfh+jsitDO+nIr+kw6/A8Zxk40iNEkfyCgGDKRsHglny0TQyy+9IU1jQKmT
46lvKoZtY2fVaKQtlAX9I2dPieGae3IiyNEezU/4J7jnxHg2rWU772+PrM8L
Lv4FYjQ5Rqx7FG0PE8JMMHtTjC0hhmvS8+zhPsCe2f1EjK0Njna6Gg6IYbaQ
nJViRCeFWYaNO8CJzS5RI0lwhbQ4v5fKxOSRvk0f1CUYoPq6H2MykdahzMox
kYCyz7BBZz8T+Xxv3TkPCTY3NLq59TLxsub6yqexEvS57am81e6IczKvx5cT
JNCInoqykTsiktwcJU2SQCnJeldJdoJ8x4ci5wwJPDqDAqn+TuC/rz30Pk8C
06MerL1FTvgPncow2A==
      "]], LineBox[CompressedData["
1:eJwVkHk01AkAxxUVWVJszkVSbe5rxrX4xobKbR25MhbZiabFjBHToHEzzQzm
92O32KbnldpQqdnSPtsqvaSyjqbU6HKsLdWGRaZd+8f3ff77vvf5bEpihKWs
VFJSCl7e/3TZUea0b5iJIkeGnbXMEp++2zjs8pQJTWpYIF9hiZuiUzkbXjGR
XNlzK3yzFcJedV29+Z6J1N6OgEWGFTJKF2ClwcLTuZ6YKA1rnOyjBy74sMC5
krElMNIGp6VUeeoeFkp0QtWpPBu0SlYyBsNY2PHsupB+wQaduQ2CVhoLDTKm
afs6WwxtuTOQwmVBrk+TivpsoXpke8wfV1nwg8ufr1rscNBmMvWsfQ7KNpib
5O9ygOuxlIJ4EzZe67zMkg5QQG3ZfSVgKxsfd9WU899S4HDTdtrdmo3ZsVl5
jjoVVh8XYg3c2XBWOr2C50OF6X6+88NINs7k0v0LLlGh6nVlOoTPRkJs+tJi
vTNk06rxXyvYUA0wU6vPdAUr6Jyr5UgudGL37HOM9sDt8dlxD34eJtZPGiXJ
vaG2ru3bgFQOnhTGKzzm/fDe6XJqtzEX8xl3T+30CkQKU2xkdKQATcJ8OftW
KEa+GuCy0wqRMD3mlWAdAXNlarOaTxFYve9U4yTRSFkfeknP7ijG0HyvXxqH
w8ai4jgNHiKyyrgTGYkozar0NFbwwIppktqOJMGYUvJ90WQxeJta84sYKSib
bd5v2F2C44V8cenqNEwpuDsdLpRC9OAf3UdrD8BkFXecIyjD9Lr20zZaByFn
c1ek08uhG1yl/sOPh1Dn5KIii6xAi509U3EoE6ZvN95hO1big3LL5gfe2ZC8
/zmHMKtCRoT/klEcC22Jvo3RGtWYUDPMrqpmQ3BPpSJoshrSF32eJdLDSOPl
xd0Y4uM20et/nMKBtqve3/SLx0DXIPemt3Bhbj2iFOsrQH5lsI9cvxDXaCX5
Xp0CmAZVp+tWF6Gzrnuvp4UQZgVtgx0LR/HLG7lF/k9CtLtpBR2qL4bJzqr4
QS0RxsONQ2PtS9Eb5tan4IiQMcNy9BgsQxav2y51RoSCi8+G97ZVgNfxfHYy
qQZL2p2ajYVVEK4dOd/yuAbZlKN0CyEfLz8fOuURUgunGWOGJEqARtOkpanr
tfBJ9EP5PiGignv9HjrVwZ27xlGpQgQ2p2fmqaQO+m5jE6xzNRildcs7tMRw
crnsVjpYC2/68c67JWJoSsuFLWbLzFRbUsyIIdKjiYdSCbRFflSemhPjFsVZ
QKYTCHN/oz48L0bXAWVOXCYBsUq/4fklMR7/dd92gkPAhCDdE1QI7O5iLq2p
I2DXuS3vV20CTb/JfHJ+JxC+2nfxiAOBZm1DA41NJOamnFcecCJwRhzaML2V
BHl/+9ooKgEz5mda/VYknpAaBrZuy7/qtCekC4lkyyHX0R0EZKo3Fh1DSLBC
knO9QgmskvgmklwSepTIQstwAtH60d7lxSSu6vuX60YQMFKmGOZVkvj0wrL+
bTQB47mT7TSCRCnzg7QxkcBoZ2WWWysJi5ixrsokAh32FE3HDhJ3PR/ezkkm
cFYS2GR1jYSW6jVZcBqBwz5fnDXrIXHh9bln7nQC2eGKzSZ9JL7pPzG5bbnT
c/MTtUYDy34dgnfaBwnc+FJHYfBo2a+haP5fBoGND7LiDUZJ/AfnsT9w
      "]], 
     LineBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAQNqKVt8lZEDb6EBzX3y0P2M1C/XH
M2RANiEKE0GhvD+GkIuTsEFkQGgcEBX3c8E/qOsLMplPZECQs7SW1R3EP8tG
jNCBXWRAit0KCzp7xj/uoQxvamtkQE+fBEYSo8g/M1gNrDuHZECtveoNooPM
P1azjUoklWRA4qak7kZLzj94Dg7pDKNkQLeBXKxP/s8/vsQOJt6+ZEAOgYbQ
mpnRP0gxEKCA9mRAWK84IZ6I1D9qjJA+aQRlQBtk8qHMOdU/jecQ3VESZUAQ
NJp5tefVP9KdERojLmVAwyo0dh071z9cChOUxWVlQANip8Llx9k/fmWTMq5z
ZUA67zVC7GbaP6HAE9GWgWVA5/Z/zZ8E2z/mdhQOaJ1lQOPdE/edPNw/cOMV
iArVZUCP04yUQ6LeP5I+libz4mVAo9DThxo63z+1mRbF2/BlQGQYPBB80d8/
+k8XAq0MZkCtGswClX/gP4S8GHxPRGZA0klIBP+r4T+mF5kaOFJmQCBYD0IA
9+E/yXIZuSBgZkAflEE1BELiPw4pGvbxe2ZAdrylESvY4j8whJqU2olmQL3C
JKZYI+M/U98aM8OXZkAXPmVSnm7jP3Y6m9GrpWZAfmzjxQC64z+YlRtwlLNm
QBYlUHaEBeQ/uvCbDn3BZkCxkrCjLVHkP7rwmw59wWZAsZKwoy1R5D+u6uuQ

      "]]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJxFxWswEwAcAPDFepCF2yXFbRLnsnNJ8xiZyqEPeWsekddmWqI8p5mhmcc8
RmHVlYvOdR0OkWJ11e0uF+pcYVmhutzsOBE7xXp96P//8Lvf/qSMMI4BgUAI
/OvfBayJPAIh+tj/Nb6CeIEVHnHYJkDnhtNMeBYLF/Cp5/reSTXu7mS/0tkf
A68YZqfFZcTC57rNEwem42Hjtu3K7nvJcEc6hf3elgvnz3suVEp5sL3Yg0xn
psOmJO4BleoivMFtManvz8Rvzs7LqrPhllFe4A/fXJhRyymKo/Lh3KB2Bk2d
Dw/Nrc151whgI9Ou5FMpQniZ/jBFSRHBnJxGa+vCIlh99K2In1oM2xm6tRn5
lsAc89BeS+cr8GVKfWksSQyXZUmZFD1OcZVcKtGUwuVrbVwrpQTW6kV+Lj1l
MHWraE4oK4en+aItabwKuIHuQVSxKmGbJYtX/CNSuHW5I6/JtgruSvBvjiJV
w7LXxMogDZ4qFsS+GK+ByQzLFd6DWtjOSU044y+DBxMlBT4KXNGgjGY61sGP
F6cdC+7gVL+quHdm9fBwmOeoXohniZXOKau4uO/TmibpKlxnrO68P4V/2T1+
1zvkGtxsk7SpfYJHBg8HTNIbYL7w5erHVnwmUTndZ9YIn+DdUoxI8F2ZRpv6
VbyLtWGo1eFhXos7J9bxRuKYVecmTm2Se50lNsHOCgfBUzIevs3/Z6ELrtO6
G5yn4/I3B40j3fAPctK+Q544mzbOmDmO54aw831CcUtXVjEtHB/Ye7Jiz2n8
12fa9aUovCzn+6PmBNwx5uszaRI+wpwcymPjZjsGVcGpeM9C+6wXD48Yu61x
SMN1fbJv5HRcfqNk/XcG/gfPLjvH
      "]]}, {}}, {{}, {}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{100., 0},
  PlotRange->{{100, 1500}, {0., 1591.7757471175914`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.545471611121005*^9}]
}, Closed]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"BRbb", "[", "mH_", "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"Ghbb", "[", "mH", "]"}], "/", 
   RowBox[{"Ghtot", "[", "mH", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BRtt", "[", "mH_", "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"Ghtt", "[", "mH", "]"}], "/", 
   RowBox[{"Ghtot", "[", "mH", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BRWW", "[", "mH_", "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"GhWW", "[", "mH", "]"}], "/", 
   RowBox[{"Ghtot", "[", "mH", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BRZZ", "[", "mH_", "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"GhZZ", "[", "mH", "]"}], "/", 
   RowBox[{"Ghtot", "[", "mH", "]"}]}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5439063007418213`*^9, 3.54390633150909*^9}, {
  3.543906361556918*^9, 3.5439063799280767`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"BRbb", "[", "mH", "]"}], ",", 
     RowBox[{"BRtt", "[", "mH", "]"}], ",", 
     RowBox[{"BRWW", "[", "mH", "]"}], ",", 
     RowBox[{"BRZZ", "[", "mH", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"mH", ",", "100", ",", "500"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Magenta", ",", "Red", ",", "Green", ",", "Blue"}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.543906337039384*^9, 3.543906350885002*^9}, {
  3.5439063876530457`*^9, 3.543906427158165*^9}, {3.543906468358563*^9, 
  3.543906470580974*^9}, {3.5439065933624763`*^9, 3.543906614801632*^9}, {
  3.54390688084383*^9, 3.543906881259019*^9}, {3.543906943801996*^9, 
  3.543906948361165*^9}, {3.545386830460163*^9, 3.545386831707758*^9}, {
  3.5453929937272043`*^9, 3.545392994046712*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[1, 0, 1], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQAWIQ7WFrq8TAEOnAAAVOp9ylb7Ej+DbhQSJb+BF8w8J0
tgx5BF9q6cRX5+0Q/Nc8zzbNr4XxF+zpu9PnbP8bIX+1+kFK3bcoOL+k2ZfJ
UTwWzr+YLPjhpXA8nH+ru87ZpzkBzg/xitxzdGIinK9bGh9r1JcE52cpzpxR
MQnBX3H20uV90xB8FTU3L+/5CL7UdR3zlA0IPpvlL4FplxD8e3+mHPkplgzn
y6w8999eGsGPDOWwbpNH8K+srd4opIHgn4pLmqdtCeMv2LPtgH5FbDRCvr/l
lPbB+Qj5koawos+LEfIRNY92qK5A8JVKfrl2bUDwtyRrJQQfROifEb9tWetR
hHxttNPb7ScRfLfgqCqZSwj+DaeuKU8fIfh77MRuiz9HmLfQapGi12uEfJbR
rnXrPiP4/npuXx98R/BNtC5ZC/9B8P8qvjpRzpIC5z+SLeNfxYHgH5NkCrvD
g+CvFu2bwyeI4E8QlHrsIIrgC0+6/G4+Eh8A6SKgng==
      "]], 
     LineBox[CompressedData["
1:eJxli2tUjHkcgKsxo7nP+9rknDa2NiWpPdNW6ij92lGo03TRUkmG/u9LLl1W
pnuMiHIkqZDL7lo5u6Yla1TE9MslIYqWirUq0d1GpQux9vN+eM5zng+PxdrY
YMbIwMBg6Wf+8yqtSzfHjEBAS3kQy/tUHcZ3jCsxJ0CZDZ6ofWmIC7n68mYL
AprZz2ZVG0xBS0PfSb41gRTJlVKfcC7yJh8p3OcSqIptNz4dxsO+sTU5MQ4E
3DtArbGaio3DA40/ORLwGrqX8qp+KuoGk02bXAicSs/N6IkwxsP93EjuAgL6
lTZm+MQY07sPnJrv+flvVN/L9OXj2k7zvmgFgfy+846Sc3z0aftNfmwxgfJf
rbxiBQKc+5dz0n0/AvuFT+PkkQKUttToDQIJDFYqlJlaAQ43+XO/DSHQdFA3
JXhIgC0NrX5MKIHn291Hw12EePUuk38ogsBkzuDd+VuFePLWm5bbKgKPPTZ3
smVC3FjNZx2iCSTwVMJAcxEGVhWWqjYT0NXJm34PEKFThcVQfjyBpAeJbtpt
Ivx41m37aDIB1RmOcUSrCDvO3Ky1zSCguEhEGzhivHU6SByxgwBn9QXTBjsx
5p2ILsYcAjOm1tnNTBJjQvFI29tcAo364d2ex8QYVqSxmX2QQCh32m6bajFa
5h7RZR8lEGxjX3TcUIK69Nv3g0sJmPUOzfyQIkFfm3ft7mUE0obbclYVSrCt
0XLEWkfgG4WkZ8Y5CYqs0szeVxEorB/j6NskSO44rP/lLgHT/ksdWR5SnNiy
MnVfA4GGBqvnmmVSzDPfk5vYREAaP1ssjJbilbh2nd9TAvYmUPMkX4ompgWG
w70EMnpW/POiXYqliF/8/ZoA3RtpfWtYit9tGLCpe0sgMbnuqZYjw5irPspj
EwREX5aG1prIsDZqvHiRgIEPVbbzlrjKUF0W6VRoy4DXxvIBdaIMReF7F2+z
Z2CXfOJJR4YMT3Iqw6PlDGjOuga6ZMnw/nJK4+HGwI3wnoKiAhlaT16/93IJ
A+9DWoOVZTJsXmq7zmU9A3Oc7lwy6ZSh64uhI82nGVirS5l850mh6qvHztO1
DCw4sAIue1O4Z1Xlg5BzDKiiipRxfhS2NqfxH1YwUJI9+vbicgpT6rnJ9XUM
jD5SdJ3dRGHVRdPQml4G2N0ft+wronDhngXTtQ4s5HnbzVr5gkL2pvkfPY4s
1KquVHR2UZhrZKCcM58F/0+s87p+Cp+n3dhV4snC4rCAsBUjFG6P9x/5MZCF
HaRyUxePxmvhq/8s+IGF8q0xg8/m0Nh7yCuuSc1C7LjmgpE9jfSjr0V0Kguv
ipSjFnIaowK6FfszWfjZjv99oBuNUxbFX8guYGFa78TRmKU0ztMsC6g7zIJa
a3002p/GEL1zH+84C8sSH1asDqLxlOuE5c4SFna6pOZ5hNHobZ+Zn1HOQkJQ
S3HNehpnzuC9T7jMwrjPmO/yTTSOGWVHbdSz0P1m3K4rlsaHA8L6NddYCIiT
+yZsobG0JdcptJYFwevK85NqGrOuU8eVd1jw/hgfk5ny//4XAyQkIA==
      "]], 
     LineBox[CompressedData["
1:eJwBUQOu/CFib1JlAgAAADQAAAACAAAAOJkXbjvSZkBHhA50raoSwBKEmtYx
1mZAH68yxW+5EsDsbh0/KNpmQB8zsoHpxRLAxlmgpx7eZkD3WmDnBdESwKBE
IxAV4mZAGahXATLbEsB5L6Z4C+ZmQKuVVBar5BLAUhop4QHqZkBW+QO1l+0S
wCwFrEn47WZA4QN2BhL2EsDg2rEa5fVmQPeQnfD1BRPAusU0g9v5ZkBDZ0xH
eA0TwJSwt+vR/WZAykPnTLwUE8BHhr28vgVnQCIXsqKjIhPArjHJXpgVZ0Dp
j2ufcDwTwHuI4KJLNWdACM0cV2dqE8BUc2MLQjlnQJpDmRXAbxPALl7mczg9
Z0AdUSH8BXUTwOIz7EQlRWdAqJWGt1x/E8BI3/fm/lRnQMHVHJhKkxPAFjYP
K7J0Z0DNTVVLp7gTwLHjPbMYtGdA1Dgofff7E8AyHhMn+7dnQAvbJGvW/xPA
sljomt27Z0B2P8zorgMUwLTNkoKiw2dAdbcGIk0LFMC2t+dRLNNnQOrLlS5C
GhTAvIuR8D/yZ0AV1NhDKDcUwMgz5S1nMGhAAY3eoIZtFMDfg4yotaxoQKMV
9Qb4zxTA8lEXpeywaECxp7GTHdMUwAQgoqEjtWhAGc/mWUDWFMAqvLeakb1o
QBRe0LV93BTAdvTijG3OaEB9CYmX2OgUwA1lOXEl8GhA06iS3BUBFcA7RuY5
lTNpQMecBR/eLxXAlwhAy3S6aUDA/omAzYcVwK75HhYntmpAbIggigMdFsBO
z2KO+8ZrQJ9uEFw8rxbAsI4629LSbEClHJU0TTMXwHK6PVCdzG1AUBL7b1Gm
F8C9yqXyidtuQPxaqGyZGxjAZ0c5vWnYb0C4V3Xg9oIYwE3UmNo1dXBARsFU
ARTtGMDI+d5AuPtwQAkTXOTnTxnAc9U6OzR5cUAtM0X/w6cZwGIjSUxBAXJA
TNSkpbQCGsCBJ23xR4ByQNMWcB/jUxrAgSDbAND8ckC8uj4AQaAawMaL+ybp
g3NA+e+8xcPvGsA6rTHh+wF0QE95pT8PNxvA80Aasp+KdEDqy3arZIEbwI3J
TO3EEHVAV0T3dJvHG8BXCJW84411QIhf/IfMBhzAaKwPjfWddUCuvJ/+wg4c
wHhMjdM=
      "]], LineBox[CompressedData["
1:eJwBkQJu/SFib1JlAgAAACgAAAACAAAAZbmPopMVdkC0TppIPlUcwKMgoBw9
lHZAlMYiwFOlHMDCfPoAaBB3QDet/zpm8xzAJksH/COXd0CGiwjShEUdwLnP
KYvZFHhARIvoOu6OHcCRxv4wIJ14QLtIru2+2h3AmHPpamAceUAo4/xhBB4e
wIEVHg8imXlAiK58e8xcHsCuKQXKdCB6QBys03uOnR7AC/QBGcGeekDRPLkD
E9cewKwwsX6eJ3tA+4AN8nYSH8AuYqpO/a17QD/nyyAJSh/A4Em5slUrfEC9
afzMoHsfwNejei0/s3xA3XgcjiavH8D9s1E8IjJ9QLEB3VhO3R/ABLlytYau
fUAvKonIbwQgwFAwRkV8NX5AuY2fvjMbIMDMXS9pa7N+QMrbMwGxLyDAGGNo
u521fkCiMA/tCjAgwGNooQ3Qt35AEMiCy2QwIMD6chOyNLx+QB2QRGAYMSDA
KIj3+v3EfkBO067pfjIgwISyv4yQ1n5ALVb6f0k1IMA9B1Cwtfl+QE2269jU
OiDAiAyJAuj7fkBA9EwgLTsgwNQRwlQa/n5AfWbRWoU7IMBsHDT5fgJ/QOHJ
VKk1PCDAmjEYQkgLf0AZVbuslT0gwPZb4NPaHH9AxNivUFNAIMBCYRkmDR9/
QL8bO8yqQCDAjWZSeD8hf0BDSiw7AkEgwCRxxBykJX9ASNlQ87BBIMBShqhl
bS5/QB5oFc0NQyDAnovht58wf0CvvELkZEMgwOmQGgrSMn9Ay6327rtDIMCA
m4yuNjd/QOicAt9pRCDAzKDFAGk5f0AvsmLEwEQgwBem/lKbO39AkpJZnRdF
IMBiqzelzT1/QF5F62luRSDArrBw9/8/f0An0BsqxUUgwFSPJC8=
      "]]}, 
    {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJwVlnk41dv3x4+ZXMqQKTKkQpHhOKGwKlQqyUyikiFDCWee1G1QolJ9VUIz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      "]]}, 
    {RGBColor[0, 1, 0], LineBox[CompressedData["
1:eJxlkns01HkYxodQhIpK6hAqxdYskthcXltbKxqyKoTI9/fLaIWUS0kp0xgy
xj0MaYpUsuTaDt6k0kWoSXSypdKuNZH7unTZ2b/3j/e853Oe857znPd59PcH
u1LyDAbDWzb/7Vj1WefpJQTC5jsFllR+wCNqRUZh2gTE7dxdYdwn6KFsFlKo
QyBaNJT9/M86tFVsqO7UJzBzIO+lmrQKDeS2f1E2JMCbUBe2+t9EpS8dm62N
CWS1nHHQNC5D6aRfwiEmgXWFRkunTW5g+9hAe4EZgZdaUnNvyTWsHIrSkljI
9ALrcyfGi/H8R0UfxU0E/Ht8FV4FX8ETfSmXN9oRCJyqy15vXIT7e3Wk7M0E
JF8nG8sXFuLWnqumwm0EhpXkCk6uvIzG3RsiWx0J+PgIlvfvvITzuhobGC4E
QpXLWp2yRDgm2aG43o3Aqesqheyhi9jV9tKRciegeKdm9VePi1j/mErN8iJw
bq5U68TTAhQ1D3c99CXQMBjT9NqtAA+iMs1kE6i9GuOjOZKPLuKMEt8gAlWP
WlLuMPPRvEZ/NDWUQP60ptQ8Kg+1K25Y3TtKYJwlwO42IX4ttTr1T5TsfnEM
L8BUiO+u3btvFEPg6HBuWY0wF5uLdqp5nSaQ+PRQ89P5uSjIZ+fcTiBgqbOs
ZdX8HDySM94zwifAtN5lyMjJRo/M2NWr0gio9wXDa6NsNOBnV/JyCQg+BHpV
eZxHpYRVM+ILBAzmFKt0TWahlFNuP3iJQCFbYwVLmIWVJx62upYQMLue4DI5
mInbV0+8tS4joKyxbM9XUSb2tBuMG1YSMKmfbO70yETVldHLZsQE4jtndexu
y0DRk2LmB5Tl1S3cVZqUgZYRHfZtTQSiav9wsmZlIHnEDLj0mMDszevtTnak
43TY3uNJbQRuB4vezOSmo0Annh8hIVC//Eq7DUnHupC3lY6vCFCnftCtnkrD
RVrpcmP9sn9eWPfC0SINS27fXvh6UNaXihzHW3PS8MfAgdUPRggYuq2Ice9O
xUP1W1nCaQJOrtsGJs6m4n3/qZwtKhTsl/RvDOxLQS81w1KmOgX8x/ZkUVMK
jlS7Ni7RoGDNVIl2Tn4K6qqU/PVRm4JS7aBedfcUDC/zMc8wogDumnQ/lwhQ
1TNx28l1FJCZ4IqISgGKZtV6sk0pCJmbg+IMAbbuXhBrY0VBYG7r6QWeAjT8
0vTkw88UsNdnf2p7lox1RUM9bU4ULONOe6vlJaOri87YLRcKovOXxNoHJGPM
pfClfHcK9I8bZwfLJWOng9EBiwAKFpWL2Hq2fDw0uuuY3q8UuBU/28max0eF
vNNJKiEURBipjdu8TUKToVcVryMoCDsw3OTETcL4TD6Dy5XxG0eW8NU5tHw/
mt1ZRIGOZ9c884uJ6Kv3YsPi6zI/Y9Jxm6hEjPeufer2GwUT5fSL7p2J+LIz
WvlZDQXqjUe3PlJIxGMtilEtDyjY8a6LxwhNQHGVlntjPwWxH2eb6/nysHdk
avTbIAV+7MjDn+x4qGrSnWw7SkHGPlvxCj0eel0raBbPUDDfVJRy8208fs43
2litSoPPnlma37Pj0TZ+0+LrTBq2RDW2yMdzkb6nc/NvMxoclopZVkFc5Msz
WGs20jDbOW9VrSsX30Tf5RTa0bA8QejE0+XiqdAd4xdcaAge6ex1u3UW73ju
e55+WKabSUa50xzsz7IPkYTT0Jd0S67sPQc1OlaoahynITKcoab+hIP+zn2b
k8/QEFTLjAwo4KDCltAKXjoNzgkW3jEOHFwb+4vzg/M0VKdZ9dmYc9CtYYNU
KY8G/jelyrXLOXjZctogrpCGgKqPqhnjcfjTujOpMdU0fNbzK42+HIe6S5Rm
jvxOQ8OwxdGRlDiclOf5H2ygIdbVOfPcyTh8NjC3xe8ODcTemr89KA5Luvjm
7vdpMNGH7u/2xuHZpgV5rEc02D3cJG/i8H/+F8hs4zM=
      "]], 
     LineBox[CompressedData["
1:eJxtz2k81AsXwHFLCqFkqVRSkspaKEZyVIrHvrVdW8J/NmumECpLieSi0EZc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      "]], 
     LineBox[CompressedData["
1:eJwV0ntczXcYB/BTI5MVFUuXUTFjiaROKUcPYYRuznJZdYqVklbU73T7XYqK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      "]]}, 
    {RGBColor[0, 0, 1], LineBox[CompressedData["
1:eJxtz2c81Q0fBvBzrIzSMkrlpoyKVEbJyK+JO5LRkwZazv8sFE5URlm5yyxK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      "]], LineBox[CompressedData["
1:eJwV03k8VtkbAHCMqKRCG0lSWZIs2bI+xpJtijfKVpSRbUy2a3nfe+9rKqFC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      
      "]]}, {}}, {{}, {}, {}, {}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{100, -17.6194268781726},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& )},
  FrameTicks->{{{{-18.420680743952367`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-13.815510557964274`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-9.210340371976182, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-4.605170185988091, 
       FormBox["0.01`", TraditionalForm]}, {0., 
       FormBox["1", TraditionalForm]}, {-15.935774094164366`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-15.285186528023216`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.894320219336205`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.614018254182046`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.395329053217216`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.215988124561399`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.063971917262773`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-13.932044374220226`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.330603908176274`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.680016342035124`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.289150033348113`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.008848068193954`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.790158867229126, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.610817938573309, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.458801731274683, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.326874188232134, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-6.725433722188183, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-6.074846156047033, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.683979847360021, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.403677882205863, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.184988681241033, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.005647752585217, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.853631545286591, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.721704002244043, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.120263536200091, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.4696759700589417`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.07880966137193, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.7985076962177716, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.579818495252942, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.40047756659712525`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2484613592984996, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.11653381625595151`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{-18.420680743952367`, 
       FormBox["\"\"", TraditionalForm]}, {-13.815510557964274`, 
       FormBox["\"\"", TraditionalForm]}, {-9.210340371976182, 
       FormBox["\"\"", TraditionalForm]}, {-4.605170185988091, 
       FormBox["\"\"", TraditionalForm]}, {0., 
       FormBox["\"\"", TraditionalForm]}, {-15.935774094164366`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-15.285186528023216`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.894320219336205`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.614018254182046`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.395329053217216`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.215988124561399`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.063971917262773`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-13.932044374220226`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.330603908176274`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.680016342035124`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.289150033348113`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.008848068193954`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.790158867229126, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.610817938573309, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.458801731274683, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.326874188232134, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-6.725433722188183, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-6.074846156047033, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.683979847360021, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.403677882205863, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.184988681241033, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.005647752585217, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.853631545286591, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.721704002244043, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.120263536200091, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.4696759700589417`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.07880966137193, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.7985076962177716, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.579818495252942, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.40047756659712525`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2484613592984996, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.11653381625595151`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}, {Automatic, Automatic}},
  GridLines->{None, None},
  ImageSize->{759., Automatic},
  Method->{},
  PlotRange->{{100, 500}, {-17.6194268781726, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, {{-18.420680743952367`, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-13.815510557964274`, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-9.210340371976182, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-4.605170185988091, 
      FormBox["0.01`", TraditionalForm]}, {0., 
      FormBox["1", TraditionalForm]}, {-15.935774094164366`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-15.285186528023216`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-14.894320219336205`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-14.614018254182046`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-14.395329053217216`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-14.215988124561399`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-14.063971917262773`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-13.932044374220226`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-11.330603908176274`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-10.680016342035124`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-10.289150033348113`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-10.008848068193954`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.790158867229126, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.610817938573309, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.458801731274683, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.326874188232134, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-6.725433722188183, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-6.074846156047033, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-5.683979847360021, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-5.403677882205863, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-5.184988681241033, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-5.005647752585217, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-4.853631545286591, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-4.721704002244043, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.120263536200091, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.4696759700589417`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.07880966137193, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.7985076962177716, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.579818495252942, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.40047756659712525`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.2484613592984996, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.11653381625595151`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}}]], "Output",
 CellChangeTimes->{
  3.543906351474853*^9, {3.543906413190082*^9, 3.543906428123044*^9}, 
   3.543906471872244*^9, {3.5439065955644836`*^9, 3.543906616473514*^9}, 
   3.543906675741301*^9, 3.5439068822741137`*^9, 3.5439069493242073`*^9, {
   3.545386832696768*^9, 3.545386855913909*^9}, 3.5453926316953077`*^9, 
   3.545392994860371*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]]
},
WindowSize->{1199, 820},
WindowMargins->{{Automatic, 75}, {Automatic, 0}},
FrontEndVersion->"8.0 for Linux x86 (64-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 1695, 38, 202, "Input"],
Cell[2255, 60, 1666, 45, 50, "Input"],
Cell[3924, 107, 1164, 34, 30, "Input"],
Cell[5091, 143, 1344, 38, 50, "Input"],
Cell[CellGroupData[{
Cell[6460, 185, 1449, 27, 50, "Input"],
Cell[7912, 214, 38672, 713, 441, "Output"]
}, Closed]],
Cell[46599, 930, 371, 8, 24, "Input"],
Cell[CellGroupData[{
Cell[46995, 942, 292, 7, 30, "Input"],
Cell[47290, 951, 2269, 43, 476, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[49596, 999, 291, 7, 24, "Input"],
Cell[49890, 1008, 4947, 88, 239, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[54874, 1101, 231, 7, 24, "Input"],
Cell[55108, 1110, 6383, 115, 236, "Output"]
}, Closed]],
Cell[61506, 1228, 878, 22, 101, "Input"],
Cell[CellGroupData[{
Cell[62409, 1254, 901, 20, 30, "Input"],
Cell[63313, 1276, 52124, 909, 480, 36676, 654, "CachedBoxData", "BoxData", \
"Output"]
}, Closed]]
}
]
*)

(* End of internal cache information *)
