* compute cross section for e+ e- --> Z H
* main production channel for Higgs boson at LEP

s x,GF,g,Mz,Mw,Mh,[sqrt(2)],Pi,lambda,[] ;
s cw,sw,v,[1+c^2],Flux,[sqrt(s)] ;
autodeclare i mu,nu ;
autodeclare s E,om,n ;
s [sqrt(lam(s,mz2,mh2))] ;
cf p1,p2,p3,p4,k1,k2 ;
cf p12,dz ;
autodeclare v vp ;
f Veez,Vzzh ;
s [p12^2-Mz^2],[1-Mz^2/s],s,t,u,z  ;
f Ub,U,Vb,V,ga ;
cf BiUU,BiVU,BiUV,Save,epsZ,del,Num ;

set zint: z ;

off statistics ;
.global


g M = Vb(p2)*Veez(mu1)*U(p1)
    * ( - d_(mu1,mu2) + p12(mu1)*p12(mu2)/Mz^2  )/[p12^2-Mz^2] 
    * Vzzh(mu2,mu3)*epsZ(p3,mu3) ;

* the EW feynman rules
id Veez(mu?) = i_*g*ga(mu)/4/cw*( 1 - 4*sw^2 - ga(5) ) ;  
id Vzzh(mu1?,mu2?) = i_*v*g^2/2/cw^2*d_(mu1,mu2) ;
.sort
id Vb(p2?)*ga(mu1?)*U(p1?) = BiVU(p2,mu1,p1) ;
id Vb(p2?)*ga(mu1?)*ga(5)*U(p1?) = BiVU(p2,mu1,5,p1) ;
b g,del,BiVU,Vb,U ;
print +s ;
.store

g Mc = M ;

* the complex conjugated
* pay attenction, when gamma_5 present, a change of sign !

id i_ = Save(-i_) ;
repeat id BiVU(p1?,mu?,p2?) = Save( BiUV(p2,mu,p1)) ;
repeat id BiVU(p1?,mu1?,5,p2?) = Save(-BiUV(p2,5,mu1,p1)) ;
repeat id BiVU(p1?,5,mu1?,p2?) = Save(-BiUV(p2,mu1,5,p1)) ;
.sort
id Save(x?) = x ;
.sort
argument ;
id mu1 = nu1 ;
id mu2 = nu2 ;
id mu3 = nu3 ;
endargument ;
b g,del,BiVU,Vb,U ;
print +s ;
.store

* the amplitude squared and averaged and summed over spins
g [|<M>|2] = 1/4*Mc*M ;

* sum over Z polarizations
id epsZ(p3,mu1?)*epsZ(p3,mu2?) = - d_(mu1,mu2) + p3(mu1)*p3(mu2)/Mz^2 ;

* build up traces
id BiVU(p2,mu1?,p1)*BiUV(p1,nu1?,p2)      = g_(1,vp2,mu1,vp1,nu1) ; 
id BiVU(p2,mu1?,5,p1)*BiUV(p1,nu1?,p2)    = g_(1,vp2,mu1,5_,vp1,nu1) ; 
id BiVU(p2,mu1?,mu2?,p1)*BiUV(p1,nu1?,p2) = g_(1,vp2,mu1,mu2,vp1,nu1) ; 

id BiVU(p2,mu1?,p1)*BiUV(p1,5,nu2?,p2)      = g_(1,vp2,mu1,vp1,5_,nu2) ; 
id BiVU(p2,mu1?,5,p1)*BiUV(p1,5,nu2?,p2)    = g_(1,vp2,mu1,5_,vp1,5_,nu2) ; 
id BiVU(p2,mu1?,mu2?,p1)*BiUV(p1,5,nu2?,p2) = g_(1,vp2,mu1,mu2,vp1,5_,nu2) ; 
id BiVU(p2,mu1?,5,p1)*BiUV(p1,nu1?,nu2?,p2) = g_(1,vp2,mu1,5_,vp1,nu1,nu2) ; 

id BiVU(p2,mu1?,p1)*BiUV(p1,nu1?,nu2?,p2)      = g_(1,vp2,mu1,vp1,nu1,nu2) ; 
id BiVU(p2,mu1?,mu2?,p1)*BiUV(p1,nu1?,nu2?,p2) = g_(1,vp2,mu1,mu2,vp1,nu1,nu2) ; 

b g,del,BiVU,BiUV,Vb,U ;
print +s ;
.sort

trace4,1 ;
id p12(nu1?) = vp1(nu1)+vp2(nu1) ;
id p1(nu1?) = vp1(nu1) ;
id p2(nu1?) = vp2(nu1) ;
id p3(nu1?) = vp3(nu1) ;
.sort

id vp1.vp1 = 0 ;
id vp2.vp2 = 0 ;
id vp3.vp3 = Mz^2 ;
id vp1.vp2 = s/2 ;
id vp1.vp3 = (Mz^2-t)/2 ;
id vp2.vp3 = (Mz^2-u)/2 ;
.sort
id u = Mz^2+Mh^2-s-t ;

print +s ;
.sort

b g,v,Mz,Mh,cw,[p12^2-Mz^2];
.sort
collect Num ;
.sort
factarg Num ;
.sort
repeat id Num(n1?,n2?,?x) = Num(n1)*Num(n2,?x) ;
.sort
id Num(n1?number_) = n1 ;
* define c = (1-4*sw^2) -> [1+c^2] = 2*(1 - 4*sw^2 + 8*sw^4)
id Num(1 - 4*sw^2 + 8*sw^4) = 1/2*[1+c^2] ;

b g,v,cw,[p12^2-Mz^2],[1+c^2];
print +s ;
.store

* cross section integrated on 2-part phase space
* check notes, z = cos(theta)

g [sigma] = 1/8/(2*Pi)^2/s*[sqrt(lam(s,mz2,mh2))]*(2*Pi)*dz(-1,1)*[|<M>|2]/Flux ;

id Num(n?) = n ;

* Kinematics 
* notice that I use here the old definition of lambda, not divided by s^2

id t = Mz^2 - 2*( E1*E3 - E1*p3*z ) ;
id E1 = [sqrt(s)]/2 ;
id E3 = (s+Mz^2-Mh^2)/2/[sqrt(s)] ;
id p3 = [sqrt(lam(s,mz2,mh2))]/2/[sqrt(s)] ;

b g,v,cw,[p12^2-Mz^2],[1+c^2],Mz,Mh,Pi,[sqrt(lam(s,mz2,mh2))],Flux,s,E1,E3;
print +s ;
.sort
id select zint dz(-1,1)*z^2 = 1/3*z^3*(replace_(z,1)-replace_(z,-1)) ;
id select zint dz(-1,1)     = z*(replace_(z,1)-replace_(z,-1)) ;
id [sqrt(lam(s,mz2,mh2))]^2 = (s-Mz^2-Mh^2)^2 - 4*Mz^2*Mh^2 ;
.sort

b g,v,cw,[p12^2-Mz^2],[1+c^2],Pi,[sqrt(lam(s,mz2,mh2))],Flux,[sqrt(s)];
.sort
collect Num ;
.sort
factarg Num ;
.sort
repeat id Num(n1?,n2?,?x) = Num(n1)*Num(n2,?x) ;
.sort

repeat id Num(n1?number_) = n1 ;
repeat id Num(n1?symbol_) = n1 ;
repeat id Num(1/n1?symbol_) = 1/n1 ;
b g,v,cw,[p12^2-Mz^2],[1+c^2],Pi,[sqrt(lam(s,mz2,mh2))],Flux,[sqrt(s)];
print +s ;
.sort

* extract factors to put cross section in the final form

multiply Save(( g^3*v/8/cw^3/Mz ),2)*( 8*cw^3*Mz/v/g^3 )^2 ;
multiply Save(1/96/Pi/s)*96*Pi*s ;
.sort

* this is defined only for internal check !!
* notice again lambda on ex-sheet is this ( lambda/s^2 )
l [lam/s^2+12*Mz^2/s] = ( (s-Mz^2-Mh^2)^2 - 4*Mh^2*Mz^2 )/s^2 + 12*Mz^2/s ;

* recall p12^2 = s
id 1/[p12^2-Mz^2]^2 = 1/s^2*Save(1/[1-Mz^2/s]^2) ;
.sort

id Num(n?) = n ;
.sort

id Mz^4/s^2 = Save( lambda/s^2 + 12*Mz^2/s ) - [lam/s^2+12*Mz^2/s]*[] ;
id []*Mz^4 = 0 ;
id [] = 1 ;

id 1/Flux = 1/(2*s) ;
id [sqrt(lam(s,mz2,mh2))] = Save(lambda/s^2,1/2)*s ;

b Save ;
* print +s ;
.sort

id Save(1/8*g^3*Mz^-1*cw^-3*v,2) = ( 1/8*g^3*Mz^-1*cw^-3*v )^2 ;

id g^2 = Mw^2*8*GF/[sqrt(2)] ;
id 1/cw = Mz/Mw ;
id v^2 = 1/[sqrt(2)]/GF ;

repeat id 1/[sqrt(2)]^2 = 1/2 ;

b Save,[1+c^2] ;
print +s ;
.sort

.end