(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    184612,       3802]
NotebookOptionsPosition[    181257,       3693]
NotebookOutlinePosition[    181593,       3708]
CellTagsIndexPosition[    181550,       3705]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Solution sheet 6", "Title",
 CellChangeTimes->{{3.542455542709993*^9, 3.542455553049755*^9}}],

Cell["Exercise 9", "Subtitle",
 CellChangeTimes->{{3.542455566715267*^9, 3.542455572082624*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"e2", "=", 
   RowBox[{"4", "\[Pi]", " ", "\[Alpha]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xWval", "=", ".23119"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.541758498472878*^9, {3.541758528954816*^9, 3.541758529333528*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"universality", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"cRmu", "\[Rule]", "cRe"}], ",", 
     RowBox[{"cLmu", "\[Rule]", "cLe"}], ",", 
     RowBox[{"cVmu", "\[Rule]", "cVe"}], ",", 
     RowBox[{"cAmu", "\[Rule]", "cAe"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LR2VA", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"cRmu", "\[Rule]", 
      RowBox[{"cVmu", "-", "cAmu"}]}], ",", 
     RowBox[{"cLmu", "\[Rule]", 
      RowBox[{"cVmu", "+", "cAmu"}]}], ",", 
     RowBox[{"cRe", "->", 
      RowBox[{"cVe", "-", "cAe"}]}], ",", 
     RowBox[{"cLe", "\[Rule]", 
      RowBox[{"cVe", "+", "cAe"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"VA2xWmu", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"cVmu", "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}], "+", 
       RowBox[{"2", "xW"}]}]}], ",", 
     RowBox[{"cAmu", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}]}], ",", 
     RowBox[{"cVe", "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}], "+", 
       RowBox[{"2", "xW"}]}]}], ",", 
     RowBox[{"cAe", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"VA2xWu", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"cVmu", "\[Rule]", 
      RowBox[{
       RowBox[{"1", "/", "2"}], "-", 
       RowBox[{
        RowBox[{"4", "/", "3"}], "xW"}]}]}], ",", 
     RowBox[{"cAmu", "\[Rule]", 
      RowBox[{"1", "/", "2"}]}], ",", 
     RowBox[{"cVe", "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}], "+", 
       RowBox[{"2", "xW"}]}]}], ",", 
     RowBox[{"cAe", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"VA2xWd", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"cVmu", "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}], "+", 
       RowBox[{
        RowBox[{"2", "/", "3"}], "xW"}]}]}], ",", 
     RowBox[{"cAmu", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}]}], ",", 
     RowBox[{"cVe", "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}], "+", 
       RowBox[{"2", "xW"}]}]}], ",", 
     RowBox[{"cAe", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}]}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5417526939980993`*^9, 3.541752718173088*^9}, {
  3.5417532471000032`*^9, 3.541753254970261*^9}, {3.541753292873304*^9, 
  3.5417533524522552`*^9}, {3.541753455461566*^9, 3.541753531244356*^9}, {
  3.541756476646092*^9, 3.541756530292715*^9}, {3.541758512293063*^9, 
  3.541758519713723*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"mZval", "=", "91.18"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalGamma]Zval", "=", "2.495"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]val", "=", 
   RowBox[{"1", "/", "137."}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GFval", "=", 
   RowBox[{"1.166", "*", 
    RowBox[{"10", "^", 
     RowBox[{"(", 
      RowBox[{"-", "5"}], ")"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"subs", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"mZ", "\[Rule]", "mZval"}], ",", 
     RowBox[{"\[CapitalGamma]Z", "\[Rule]", "\[CapitalGamma]Zval"}], ",", 
     RowBox[{"\[Alpha]", "\[Rule]", "\[Alpha]val"}], ",", 
     RowBox[{"GF", "\[Rule]", "GFval"}], ",", 
     RowBox[{"xW", "\[Rule]", "xWval"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5413524682906*^9, 3.541352630500876*^9}, {
   3.541352669679874*^9, 3.541352712478033*^9}, {3.541352745009202*^9, 
   3.541352797090053*^9}, {3.541352829562923*^9, 3.541352955294026*^9}, {
   3.5413529976639643`*^9, 3.541353011815634*^9}, {3.54135308405639*^9, 
   3.541353114098694*^9}, {3.5413531509661827`*^9, 3.541353152534398*^9}, {
   3.541353291555743*^9, 3.541353292598824*^9}, {3.54135335050854*^9, 
   3.541353351157428*^9}, {3.541353429287468*^9, 3.5413534512785997`*^9}, {
   3.541353506107168*^9, 3.541353535411365*^9}, {3.5413535935195913`*^9, 
   3.541353623468655*^9}, {3.5413541238590717`*^9, 3.541354132675117*^9}, 
   3.541746586454042*^9, {3.5417475758639603`*^9, 3.541747576535838*^9}, {
   3.5417561023972607`*^9, 3.5417561031985617`*^9}, {3.5417562355548983`*^9, 
   3.541756282581258*^9}, {3.5417585343335047`*^9, 3.541758540057995*^9}, {
   3.541760909630197*^9, 3.54176092238615*^9}, {3.542456034417697*^9, 
   3.5424560388505363`*^9}, {3.5424580708039017`*^9, 
   3.5424580868181143`*^9}, {3.5424581634673567`*^9, 3.542458172456118*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "[", "s_", "]"}], ":=", 
  RowBox[{
   FractionBox[
    RowBox[{
     SqrtBox["2"], "GF", "*", 
     RowBox[{"mZ", "^", "2"}]}], 
    RowBox[{"s", "-", 
     RowBox[{"mZ", "^", "2"}], "+", 
     RowBox[{"I", " ", "mZ", "*", "\[CapitalGamma]Z"}]}]], "*", 
   FractionBox["s", "e2"]}]}]], "Input",
 CellChangeTimes->{{3.5417470607366447`*^9, 3.541747061757928*^9}, {
   3.541747865703392*^9, 3.541747871291313*^9}, {3.5417540695314817`*^9, 
   3.54175414575478*^9}, 3.5417559287230062`*^9, {3.541758561223399*^9, 
   3.541758564396954*^9}, {3.541758621913096*^9, 3.541758635606028*^9}, 
   3.541759170001021*^9, {3.5417603760727987`*^9, 3.541760399395177*^9}, {
   3.542457533840127*^9, 3.5424575340845957`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ALL", "=", 
   RowBox[{
    RowBox[{"s", "^", "2"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "c"}], ")"}], "^", "2"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ARR", "=", "ALL"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ALR", "=", " ", 
   RowBox[{
    RowBox[{"s", "^", "2"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "c"}], ")"}], "^", "2"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ARL", "=", "ALR"}], ";"}]}], "Input",
 CellChangeTimes->{{3.541747283831642*^9, 3.541747343610346*^9}, {
  3.5424556058312197`*^9, 3.542455609490861*^9}, {3.542457316916408*^9, 
  3.542457318057312*^9}}],

Cell[CellGroupData[{

Cell["vii)", "Subsubtitle",
 CellChangeTimes->{{3.5424556689973392`*^9, 3.5424556699504766`*^9}, {
  3.542457229510214*^9, 3.542457230562014*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ee2mumu", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"64", 
      RowBox[{"\[Pi]", "^", "2"}], " ", "s"}]], 
    RowBox[{
     RowBox[{"(", 
      FractionBox["e2", "s"], ")"}], "^", "2"}], 
    RowBox[{"ComplexExpand", "[", 
     RowBox[{
      FractionBox["1", "4"], "\[IndentingNewLine]", "  ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", "Rer", " ", "cRmu", " ", "cRe"}], "+", 
           RowBox[{"Absr2", " ", 
            RowBox[{"cRmu", "^", "2"}], " ", 
            RowBox[{"cRe", "^", "2"}]}]}], ")"}], "ARR"}], "+", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", "Rer", " ", "cRmu", " ", "cLe"}], "+", 
           RowBox[{"Absr2", " ", 
            RowBox[{"cRmu", "^", "2"}], " ", 
            RowBox[{"cLe", "^", "2"}]}]}], ")"}], "ARL"}], "+", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", "Rer", " ", "cLmu", " ", "cRe"}], "+", 
           RowBox[{"Absr2", " ", 
            RowBox[{"cLmu", "^", "2"}], " ", 
            RowBox[{"cRe", "^", "2"}]}]}], ")"}], "ALR"}], "+", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", "Rer", " ", "cLmu", " ", "cLe"}], "+", 
           RowBox[{"Absr2", " ", 
            RowBox[{"cLmu", "^", "2"}], " ", 
            RowBox[{"cLe", "^", "2"}]}]}], ")"}], "ALL"}]}], ")"}]}], "]"}]}],
    "]"}]}]], "Input",
 CellChangeTimes->CompressedData["
1:eJwdx0EoQwEAh/HHylFqLHuaWnajKA4OFK+21IaYemZamKUebzthDrYoWa+Y
tnoO4rBGdrDeGDfaqLWW1tCrteImzw5s1+3A+7/D169Pv+SZdjUSBNEuBztv
jy5nneVRs4qMwcUpUoAZfS0B35ifOxg67rlXVOezcMtiycGhxPIrHNjUvkP+
hpYU1bVvmPpdbbLJDgZExYuMrxW+bLhJuDNf74IRo9sArVF/N/SI4V5IaYOT
sNjsn4GCLsDApFPFwqs2HW2XXdirumBDSmLgaYudhfvc3zp8KH1sw9Bw3y4U
NVZFik1zMC5oDqBUp8KQXsvF4FnVHIeGE/4aeg8f0zAS9D3BFbEjC7lKQXGE
Hy/CaH6iBB3P4ic0nfd/wWTFZHPgC2Nz8B8QpL/1
  "]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"16", " ", "s"}]], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Absr2", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["cLe", "2"], "+", 
        SuperscriptBox["cRe", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["cLmu", "2"], "+", 
        SuperscriptBox["cRmu", "2"]}], ")"}]}], "+", 
     RowBox[{"2", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{"cLe", "-", "cRe"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"cLmu", "-", "cRmu"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Absr2", " ", 
         RowBox[{"(", 
          RowBox[{"cLe", "+", "cRe"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"cLmu", "+", "cRmu"}], ")"}]}], "+", 
        RowBox[{"2", " ", "Rer"}]}], ")"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"cLmu", " ", "cRe", " ", "Rer"}], "+", 
        RowBox[{"cRe", " ", "cRmu", " ", "Rer"}], "+", 
        RowBox[{"cLe", " ", 
         RowBox[{"(", 
          RowBox[{"cLmu", "+", "cRmu"}], ")"}], " ", "Rer"}]}], ")"}]}], "+", 
     
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Absr2", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["cLe", "2"], "+", 
           SuperscriptBox["cRe", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["cLmu", "2"], "+", 
           SuperscriptBox["cRmu", "2"]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", 
           RowBox[{"cLmu", " ", "cRe", " ", "Rer"}], "+", 
           RowBox[{"cRe", " ", "cRmu", " ", "Rer"}], "+", 
           RowBox[{"cLe", " ", 
            RowBox[{"(", 
             RowBox[{"cLmu", "+", "cRmu"}], ")"}], " ", "Rer"}]}], ")"}]}]}], 
       ")"}]}]}], ")"}], " ", 
   SuperscriptBox["\[Alpha]", "2"]}]}]], "Output",
 CellChangeTimes->{
  3.541752762539888*^9, {3.541752797437146*^9, 3.541752815360694*^9}, 
   3.54175285152715*^9, {3.541752920036553*^9, 3.5417529377884817`*^9}, {
   3.5417530047934093`*^9, 3.541753036265226*^9}, {3.5417530669158487`*^9, 
   3.541753167086403*^9}, 3.541753207347948*^9, {3.541753360454883*^9, 
   3.541753373150689*^9}, 3.5417534150617723`*^9, 3.541753555133771*^9, {
   3.541753652652828*^9, 3.54175365848837*^9}, 3.5417559638222637`*^9, 
   3.541756116361156*^9, 3.541756328087618*^9, 3.541757413986308*^9, 
   3.541758647055771*^9, 3.5417586928130903`*^9, 3.541759221495376*^9, 
   3.5417604193327627`*^9, 3.541760926049306*^9, 3.5417611309985113`*^9, 
   3.542455616003676*^9, 3.542457232267565*^9, 3.5424573232398252`*^9, 
   3.542457427001979*^9, 3.5424575391179953`*^9, 3.5424578390828257`*^9, 
   3.542458024021667*^9, 3.542458177891706*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"4", "s"}], 
     RowBox[{"\[Alpha]", "^", "2"}]], "ee2mumu"}], "/.", "universality"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{"%", ",", "c", ",", "2"}], "]"}], "//", "FullSimplify"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{
     RowBox[{"%%", "-", 
      RowBox[{"%", "*", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", "c", ",", "1"}], "]"}], "//",
    "FullSimplify"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%%", "/.", "LR2VA"}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%%", "/.", "LR2VA"}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%%", "/.", "VA2xWmu"}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%%", "/.", "VA2xWmu"}], "//", "FullSimplify"}]}], "Input",
 CellChangeTimes->{{3.541753662631085*^9, 3.541753664266098*^9}, {
  3.5417604334584846`*^9, 3.541760437112393*^9}, {3.54245564618038*^9, 
  3.542455651333177*^9}, {3.542457326810104*^9, 3.542457330503132*^9}}],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"Absr2", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["cAe", "2"], "+", 
      SuperscriptBox["cVe", "2"]}], ")"}], "2"]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["cVe", "2"], " ", "Rer"}]}]], "Output",
 CellChangeTimes->{
  3.5417536651412783`*^9, 3.541755965399069*^9, 3.5417560129170628`*^9, 
   3.541756119645303*^9, 3.541756329561903*^9, 3.541757415522832*^9, 
   3.541758698596436*^9, 3.5417592225088873`*^9, 3.541760438131778*^9, 
   3.541760927399207*^9, 3.541761132253933*^9, {3.542455629237578*^9, 
   3.542455651827591*^9}, 3.5424572345571747`*^9, {3.542457327234934*^9, 
   3.542457331000383*^9}, 3.542457427925769*^9, 3.542457540987275*^9, 
   3.542457845466091*^9, 3.5424580255048532`*^9, 3.542458178834543*^9}],

Cell[BoxData[
 RowBox[{"4", " ", 
  SuperscriptBox["cAe", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", "Absr2", " ", 
     SuperscriptBox["cVe", "2"]}], "+", "Rer"}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.5417536651412783`*^9, 3.541755965399069*^9, 3.5417560129170628`*^9, 
   3.541756119645303*^9, 3.541756329561903*^9, 3.541757415522832*^9, 
   3.541758698596436*^9, 3.5417592225088873`*^9, 3.541760438131778*^9, 
   3.541760927399207*^9, 3.541761132253933*^9, {3.542455629237578*^9, 
   3.542455651827591*^9}, 3.5424572345571747`*^9, {3.542457327234934*^9, 
   3.542457331000383*^9}, 3.542457427925769*^9, 3.542457540987275*^9, 
   3.542457845466091*^9, 3.5424580255048532`*^9, 3.5424581788355637`*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{"4", "+", 
    RowBox[{"2", " ", "Rer", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"4", " ", "xW"}]}], ")"}], "2"]}], "+", 
    RowBox[{"Absr2", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"4", " ", "xW"}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["xW", "2"]}]}], ")"}], "2"]}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.5417536651412783`*^9, 3.541755965399069*^9, 3.5417560129170628`*^9, 
   3.541756119645303*^9, 3.541756329561903*^9, 3.541757415522832*^9, 
   3.541758698596436*^9, 3.5417592225088873`*^9, 3.541760438131778*^9, 
   3.541760927399207*^9, 3.541761132253933*^9, {3.542455629237578*^9, 
   3.542455651827591*^9}, 3.5424572345571747`*^9, {3.542457327234934*^9, 
   3.542457331000383*^9}, 3.542457427925769*^9, 3.542457540987275*^9, 
   3.542457845466091*^9, 3.5424580255048532`*^9, 3.54245817883648*^9}],

Cell[BoxData[
 RowBox[{"Rer", "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "Absr2", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"4", " ", "xW"}]}], ")"}], "2"]}]}]], "Output",
 CellChangeTimes->{
  3.5417536651412783`*^9, 3.541755965399069*^9, 3.5417560129170628`*^9, 
   3.541756119645303*^9, 3.541756329561903*^9, 3.541757415522832*^9, 
   3.541758698596436*^9, 3.5417592225088873`*^9, 3.541760438131778*^9, 
   3.541760927399207*^9, 3.541761132253933*^9, {3.542455629237578*^9, 
   3.542455651827591*^9}, 3.5424572345571747`*^9, {3.542457327234934*^9, 
   3.542457331000383*^9}, 3.542457427925769*^9, 3.542457540987275*^9, 
   3.542457845466091*^9, 3.5424580255048532`*^9, 3.54245817883737*^9}]
}, Open  ]],

Cell["which is the result from Halzen & Martin (Section 13.6)", "Text",
 CellChangeTimes->{{3.542455698318573*^9, 3.5424557250494204`*^9}, {
  3.542457235988132*^9, 3.542457236928317*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A0", "[", "s_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"2", "*", 
      RowBox[{"Re", "[", 
       RowBox[{"r", "[", "s", "]"}], "]"}], 
      RowBox[{"cVe", "^", "2"}]}], "+", 
     RowBox[{
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"r", "[", "s", "]"}], "]"}], "^", "2"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"cVe", "^", "2"}], "+", 
         RowBox[{"cAe", "^", "2"}]}], ")"}], "^", "2"}]}]}], "/.", 
    "VA2xWmu"}], "/.", "subs"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A1", "[", "s_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"4", 
      RowBox[{"Re", "[", 
       RowBox[{"r", "[", "s", "]"}], "]"}], 
      RowBox[{"cAe", "^", "2"}]}], "+", 
     RowBox[{"8", 
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"r", "[", "s", "]"}], "]"}], "^", "2"}], 
      RowBox[{"cVe", "^", "2"}], 
      RowBox[{"cAe", "^", "2"}]}]}], "/.", "VA2xWmu"}], "/.", 
   "subs"}]}]}], "Input",
 CellChangeTimes->{{3.541355087943954*^9, 3.541355089536943*^9}, 
   3.541747052377713*^9, 3.54176502120772*^9, {3.542455826106526*^9, 
   3.542455907602364*^9}, {3.542456042912359*^9, 3.54245604548217*^9}, {
   3.542456241014434*^9, 3.5424562536364737`*^9}, {3.542457391421735*^9, 
   3.542457394408065*^9}, {3.542457593999712*^9, 3.542457596212287*^9}, {
   3.5424579967925587`*^9, 3.542458005694347*^9}, {3.542458186431979*^9, 
   3.542458223507481*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["viii)", "Subsubtitle",
 CellChangeTimes->{{3.5424565473781548`*^9, 3.542456549064818*^9}, {
  3.542457457741992*^9, 3.542457458337886*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"\[Alpha]val", "^", "2"}], 
       RowBox[{"4", "*", 
        RowBox[{"34", "^", "2"}]}]], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"c", "*", "c"}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[Alpha]val", "^", "2"}], 
       RowBox[{"4", "*", 
        RowBox[{"34", "^", "2"}]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"A0", "[", 
          RowBox[{"34", "^", "2"}], "]"}], 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"A1", "[", 
          RowBox[{"34", "^", "2"}], "]"}], "c"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"\[Alpha]val", "^", "2"}], 
       RowBox[{"4", 
        RowBox[{"mZval", "^", "2"}]}]], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"c", "*", "c"}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[Alpha]val", "^", "2"}], 
       RowBox[{"4", 
        RowBox[{"mZval", "^", "2"}]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"A0", "[", 
          RowBox[{"mZval", "^", "2"}], "]"}], 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"A1", "[", 
          RowBox[{"mZval", "^", "2"}], "]"}], "c"}]}], ")"}]}]}], 
    "\[IndentingNewLine]", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.5413542924703293`*^9, 3.541354344662171*^9}, {
  3.542456110714719*^9, 3.542456146611937*^9}, {3.542456184384749*^9, 
  3.5424561983401117`*^9}, {3.54245630938559*^9, 3.5424563750671053`*^9}, {
  3.542456413540618*^9, 3.5424564273026133`*^9}, {3.542456573880024*^9, 
  3.542456576496345*^9}, {3.542456642546097*^9, 3.542456655564066*^9}, {
  3.542456732543172*^9, 3.542456749968614*^9}, {3.5424576004784117`*^9, 
  3.54245760260083*^9}, {3.54245809854955*^9, 3.5424581034836407`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw113k0VV3YAHChFGXqxVshQwmVKJTk2Sg55yJDhptkKk1o8JoplEopqcgs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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwt13k4Fe8XAHAlpWSrKGXfCV+0Ks7RpplbsuSWutaijSgpIkvaKJWilWTt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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 1.15*^-8},
  PlotRange->{{-1, 1}, {1.139014778521476*^-8, 2.5890319261603675`*^-8}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.541354304724992*^9, 3.541354345324028*^9}, 
   3.5413550916300373`*^9, 3.542455912399139*^9, 3.542456048309568*^9, 
   3.5424561113509073`*^9, {3.542456147588266*^9, 3.542456156874117*^9}, 
   3.542456198976305*^9, 3.542456261060602*^9, 3.5424563111763363`*^9, {
   3.5424563480497713`*^9, 3.5424563758558693`*^9}, 3.542456428927944*^9, 
   3.542456522875592*^9, 3.542456577418768*^9, 3.542456645744712*^9, {
   3.5424567287359533`*^9, 3.542456750864715*^9}, 3.542457242064281*^9, 
   3.5424573970240593`*^9, {3.542457433529715*^9, 3.542457459763625*^9}, 
   3.542457547996149*^9, 3.542457603339952*^9, 3.542457668918545*^9, 
   3.54245785715975*^9, {3.542458094048625*^9, 3.542458104347435*^9}, {
   3.5424582410239677`*^9, 3.542458259953162*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw1V3k0lmv3NiShhKKj5yFzvK9ESans21RJidDgq0gn6SSFMh1CpswZy5TM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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwt13k0ldsbB3BDZZar1HWVkDmEikx7Vwp1zbcu90bSIBdFMg+RVAgZ3oPM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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-1, 1}, {0., 6.209851895743489*^-7}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.541354304724992*^9, 3.541354345324028*^9}, 
   3.5413550916300373`*^9, 3.542455912399139*^9, 3.542456048309568*^9, 
   3.5424561113509073`*^9, {3.542456147588266*^9, 3.542456156874117*^9}, 
   3.542456198976305*^9, 3.542456261060602*^9, 3.5424563111763363`*^9, {
   3.5424563480497713`*^9, 3.5424563758558693`*^9}, 3.542456428927944*^9, 
   3.542456522875592*^9, 3.542456577418768*^9, 3.542456645744712*^9, {
   3.5424567287359533`*^9, 3.542456750864715*^9}, 3.542457242064281*^9, 
   3.5424573970240593`*^9, {3.542457433529715*^9, 3.542457459763625*^9}, 
   3.542457547996149*^9, 3.542457603339952*^9, 3.542457668918545*^9, 
   3.54245785715975*^9, {3.542458094048625*^9, 3.542458104347435*^9}, {
   3.5424582410239677`*^9, 3.542458260058465*^9}}]
}, Open  ]],

Cell["\<\
For s = mZ^2 (second graph) the QED cross section is almost invisible. \
Although it is not clearly visible, the asymmetry is still there.\
\>", "Text",
 CellChangeTimes->{{3.542456582606209*^9, 3.542456678924811*^9}, {
  3.5424567104359093`*^9, 3.542456716489386*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "+", 
        RowBox[{"c", "^", "2"}]}], ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"A0", "[", "s", "]"}], 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"c", "^", "2"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"A1", "[", "s", "]"}], "c"}]}], ")"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "0", ",", 
     RowBox[{"mZval", "^", "2"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5413529268130407`*^9, 3.54135292770963*^9}, {
   3.541352958828969*^9, 3.541352990725382*^9}, {3.541353024255234*^9, 
   3.541353044789173*^9}, {3.5413531789953423`*^9, 3.541353187427072*^9}, {
   3.5413535376190443`*^9, 3.5413535469791107`*^9}, {3.541353652340234*^9, 
   3.541353662377412*^9}, {3.541353706148226*^9, 3.541353754925845*^9}, {
   3.541353792376466*^9, 3.5413538030957413`*^9}, {3.5424559309773197`*^9, 
   3.542455931374104*^9}, {3.542456487996027*^9, 3.542456488184742*^9}, 
   3.542457606938468*^9, 3.5424582462424498`*^9}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`s$$ = 3473.4513027254493`, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`s$$], 0, 8313.792400000002}}, Typeset`size$$ = {
    360., {113., 117.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`s$7145$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`s$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`s$$, $CellContext`s$7145$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[{1 + $CellContext`c^2, $CellContext`A0[$CellContext`s$$] (
           1 + $CellContext`c^2) + $CellContext`A1[$CellContext`s$$] \
$CellContext`c}, {$CellContext`c, -1, 1}], 
      "Specifications" :> {{$CellContext`s$$, 0, 8313.792400000002, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, DefaultBaseStyle -> 
        "Animate", DefaultLabelStyle -> "AnimateLabel", SynchronousUpdating -> 
        True, ShrinkingDelay -> 10.}, "DefaultOptions" :> {}],
     ImageSizeCache->{405., {148., 153.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Animate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.541352991480177*^9, 3.541353046004489*^9}, {
   3.541353085782998*^9, 3.541353115567288*^9}, 3.541353154697567*^9, 
   3.541353188066167*^9, 3.541353296506935*^9, 3.54135335271665*^9, {
   3.541353432990847*^9, 3.541353453809533*^9}, 3.5413535786984787`*^9, {
   3.541353662971447*^9, 3.541353755552569*^9}, 3.541353804104054*^9, 
   3.5413541355117064`*^9, 3.541355093867092*^9, {3.5424559253564653`*^9, 
   3.542455954411456*^9}, 3.542456051724992*^9, 3.542456265476843*^9, 
   3.54245648880554*^9, 3.542457245521387*^9, 3.5424574003974524`*^9, 
   3.542457462147934*^9, 3.54245755424271*^9, 3.542457608618264*^9, 
   3.542457671171871*^9, 3.5424578600061417`*^9, 3.542458106732791*^9, 
   3.542458246723682*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ix)", "Subsubtitle",
 CellChangeTimes->{{3.542456818754444*^9, 3.5424568274920893`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"integrand", "[", "c_", "]"}], ":=", 
  RowBox[{
   RowBox[{"a0", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"c", "^", "2"}]}], ")"}]}], "+", 
   RowBox[{"a1", " ", "c"}]}]}]], "Input",
 CellChangeTimes->{{3.542456941661449*^9, 3.5424569477002087`*^9}, {
  3.542458401376829*^9, 3.542458421880918*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"F", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"integrand", "[", "c", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "0", ",", "1"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"B", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"integrand", "[", "c", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 FractionBox[
  RowBox[{"F", "-", "B"}], 
  RowBox[{"F", "+", "B"}]]}], "Input",
 CellChangeTimes->{{3.542458425302547*^9, 3.542458465067075*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"4", " ", "a0"}], "3"], "+", 
  FractionBox["a1", "2"]}]], "Output",
 CellChangeTimes->{{3.542458455390551*^9, 3.5424584656894836`*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"4", " ", "a0"}], "3"], "-", 
  FractionBox["a1", "2"]}]], "Output",
 CellChangeTimes->{{3.542458455390551*^9, 3.5424584656905527`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", "a1"}], 
  RowBox[{"8", " ", "a0"}]]], "Output",
 CellChangeTimes->{{3.542458455390551*^9, 3.54245846569145*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"A", "[", "s_", "]"}], ":=", 
  FractionBox[
   RowBox[{"3", 
    RowBox[{"A1", "[", "s", "]"}]}], 
   RowBox[{"8", 
    RowBox[{"A0", "[", "s", "]"}]}]]}]], "Input",
 CellChangeTimes->{{3.541354802739399*^9, 3.54135480559533*^9}, {
  3.541354872784093*^9, 3.541354901287347*^9}, {3.5424576123470373`*^9, 
  3.542457617249571*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"A", "[", "s", "]"}], "/.", "VA2xWmu"}], "/.", "subs"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "0", ",", 
     RowBox[{"2", 
      RowBox[{"mZval", "^", "2"}]}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.541355552093319*^9, 3.541355561387374*^9}, {
   3.542457257118908*^9, 3.542457257328868*^9}, 3.5424575686992683`*^9, 
   3.542457619588642*^9, 3.5424582794904547`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nk4VN8bAHBbKmVJktJiKaUUCVnSeUULEmVNkSRbJfVFhVRSigilRYoi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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 16627.584800000004`}, {-0.7378999941487664, 
    0.7492129311483423}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5413555618427353`*^9, 3.542457258077149*^9, 3.542457405678938*^9, {
   3.542457439734725*^9, 3.5424574792526493`*^9}, {3.542457559883627*^9, 
   3.542457569685629*^9}, 3.542457620172736*^9, 3.5424576762071238`*^9, 
   3.54245786663993*^9, 3.542458113867985*^9, {3.542458276905282*^9, 
   3.5424582808931417`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Note on the cross section magnitudes:\
\>", "Subsubtitle",
 CellChangeTimes->{{3.542458556545534*^9, 3.542458580890218*^9}}],

Cell["\<\
The total cross section as a function of the center of mass energy:\
\>", "Text",
 CellChangeTimes->{{3.5424584944062138`*^9, 3.542458524238304*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Sigma]QED", "[", "s_", "]"}], ":=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"c", "^", "2"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]EW", "[", "s_", "]"}], ":=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"A0", "[", "s", "]"}], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"c", "^", "2"}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"A1", "[", "s", "]"}], "c"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.541352742407936*^9, 3.541352743085376*^9}, {
  3.5413538241196003`*^9, 3.5413538832415543`*^9}, {3.5424578116156597`*^9, 
  3.5424578269322157`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Alpha]val", "^", "2"}], 
      RowBox[{
       RowBox[{"\[Sigma]QED", "[", "s", "]"}], "/", 
       RowBox[{"(", 
        RowBox[{"4", "s"}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"\[Alpha]val", "^", "2"}], 
      RowBox[{
       RowBox[{"\[Sigma]EW", "[", "s", "]"}], "/", 
       RowBox[{"(", 
        RowBox[{"4", "s"}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "0", ",", 
     RowBox[{"2", "*", 
      RowBox[{"mZval", "^", "2"}]}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.541353890749543*^9, 3.54135407795945*^9}, {
  3.5424568388781137`*^9, 3.542456889416216*^9}, {3.5424569736647882`*^9, 
  3.542456974187344*^9}, {3.5424583492177773`*^9, 3.54245834954602*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1Gk8lIsaAHBZWhxXRvHLUrLcjqlm5n3nLZHUU8ORDh3bVKQmJ0tGobIr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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJw92Hk8VO/3AHCJIlJKKvoglS1m5l4SQqdoJ6IJJVuWrBXa7CmFyBIpyk6y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     "]], LineBox[CompressedData["
1:eJwV0Hk4lYkeB3AylqtuIWtyaJGl65z3fQ8iSz8c6ZibFtHVYk4oVJe0iLQI
mST7GUlpRGOUNJbETKnf+55zUOSc6cqWsiQuUR5ZZm7KvPeP3/N9Pv98n+/z
WxEUuX3/AiUlpUj2/p/hh2UxadcR/FY6+NVr22CgtWph202EUG6L0MvSBjmL
JEnSWgTXkunfHb+3wRtyV59bbxEqNO19Rl252J7a7h00hOAiyzzVK+Ti4k0R
XmYjCK0zi2yYHVw8iwVw/QPCYVG885aDXAysnKPEfyKoNXyNShRzkZPzm0HS
EhpsSwzjBe+4eMPfvj/YiYbUBz7iMzE8vHg7549JFxrmyn6nk+J5eGxuYkkC
0OC2dH7s9EUebioqcy30pKGoinwCeTycHDe73rOFBvu72RNGtTz0urBwp18I
DcLwimLeJA8nqvtaNqbRsFHrtM4BHoHdaq6DLzNouFd+zfgqRaAs4NrnkGwa
tmfc/7HBjsD8eT/rxCs0cJcrb9N2JlDwbfP3T27S4KRl0XVgE4F5AzXuDg9o
WN7msZgjItBNO7XOqpcGk6RzqjqXCXxU3lv7sZ/dE7Dnp8F0Au29bWtrBmlQ
6vpnSlUWgWsTX9e4jdLQdrzcB64QqDfNqw6YpsHYIMjUvIjAkc628pSFDOy7
r9FpUktgViGneGQdA3HcO566bwhc5HKs6Jf1DNQ1L0gI6SMwuavx5gkXBn5w
aPGqHCAwTieqUNmDAUbingnDBO5PkhQY+TCwbNzwk/0EgY5hYXnCEAbSmZ6i
FGUS+3lVabczGQinAy1nV5C4YKonNyiHgZSH3ldfryJxdZ16oXEuAztDAy7Q
5iSGwd6qtGsMHOR0vT1vReKHrRodUSUMFOj/KXxHkPi/qECz9Y8YEIw3ajht
IFHnvmb1s2EGNqRzl7rvItE2xu5R4igDBGpq9e8m0c9ZJHMeZ+BEaaP+2b0k
5klrOu5NMmAURW+tEpHIeSmay/7CwLi8rEcllETrmQeeu5dKAOrb9/scI9Hd
IbjzvasEtqnYaeZdIlE/x3fuhJsE9nLFdUOpJI6Oe5gpCSTQ4Wi/0DaNxOzi
1WG6QgnUfdYreZZB4sDioVlnXwmsbf7jw7CYxMR3YQbpoRLI2ZBcPHiDRGl2
hD+RKYER1A+eqiTRazy27Xi/BEo42pOtbSTezdrXZzcoAbUnsvT3L0nUsheO
zQxJIOANoaveQWLnWcNvYsckcOZDT+/6LvZ/WrX8M7MSeIVlpT+8JvEifyr7
wt+lcO80ccBoiMSm2IhtuY5SMHSYXh4yQ6JQLbi1NksKTp0jzDZdCkVuWtNC
sRQeJ35qX61HYfTpeuOeXCkMpyS7zbK+NWkQrnRdCqWexSb5BhR+fdOiIiyR
QtPf3mp0LqOwqtbesfs3KXBEASK7FRQuD9e8NfdWCnsGqk/E2VD4sbky1s1e
Bh6B647sEVB4l2t3p8FBBr1bTl5U96TwYFZd97dOMqgRiCyrWA/5P3HyBxls
bPFWVvOisKe/5ctBbxmoZJqvKRVS+HR2+Lw4UAZ+9Sn32n0oLF7FuTScLIPT
WeGWff+icGfcpfy0DhnUeUcqPT5E4cN0u19zkhug677+zU8ZFEp8Nqb0WTXC
qMxXR7mcwqajVjuHuxvhF61zu6ObKIzyONpuG98Em/d7Tmj3Uvjqi6BZsPIp
aKq/3zQ+SaH78tH6xS+eQtvD8Uh/NT5uHp7aZxr9DN60HZY91eejn/4LlVGL
ZmAO7GcMLPjI4Tkan2xnfbznaLMdH1OnVAe9Y1ugInF2LMGdj9MmP93ptHoO
C4KKBHu28FFl6vbK8tbn0EBFL8zdxcf/VDtoCY60QmrT5bGpED7+2HH1s9hU
Dqpq8SJxJB+XlIry/iGRw6FvTI/MxvBxKttFW71BDoknTYRmsXzsPrPsUn+T
HJS79IyErEt82+JyW+VQsE/1Rj5r13mv75S65SCn/ZxdTvExwp+3pm1CDk+p
kNb4OD6GLpjvclmigMeZIyHKZ9m+k//WL9NSgEzf2tyK9ebxV9sNdRTwUWu4
Zytrfmdd86SuAo58fUcVsp4vP1r/8zIFzEeHxLqe4+OVgKFC7TUKEAvoY7Hx
fNSU73h91kIBhqZ55YWszwgkRmOWCnD81bK3kXUwrzC7Ya0CMiySrfTP85Gn
uispjlTAV7f83VWsi0414X8pBVDxP/t2sdabsP/iZ6sADbvLHkoJfPzcvTSa
WKcA64pRTR/WEVsTqgocFODWeGjgOOt+2cQHzfUKyJt5UXmN9Q6n79bGOCmg
uG9VLMO6seJ56DtnBcSYBzmMsP4LFSdsOw==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, -19.96424526948679},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& )},
  FrameTicks->{{{{-20.72326583694641, 
       FormBox[
        TemplateBox[{"1", 
          TemplateBox[{"10", 
            RowBox[{"-", "9"}]}, "Superscript", SyntaxForm -> 
           SuperscriptBox]}, "Row", 
         DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
         InterpretationFunction -> (RowBox[{"Row", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )],
         TraditionalForm]}, {-19.11382792451231, 
       FormBox[
        TemplateBox[{"5", 
          TemplateBox[{"10", 
            RowBox[{"-", "9"}]}, "Superscript", SyntaxForm -> 
           SuperscriptBox]}, "Row", 
         DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
         InterpretationFunction -> (RowBox[{"Row", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )],
         TraditionalForm]}, {-18.420680743952367`, 
       FormBox[
        TemplateBox[{"1", 
          TemplateBox[{"10", 
            RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> 
           SuperscriptBox]}, "Row", 
         DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
         InterpretationFunction -> (RowBox[{"Row", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )],
         TraditionalForm]}, {-16.811242831518264`, 
       FormBox[
        TemplateBox[{"5", 
          TemplateBox[{"10", 
            RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> 
           SuperscriptBox]}, "Row", 
         DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
         InterpretationFunction -> (RowBox[{"Row", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )],
         TraditionalForm]}, {-16.11809565095832, 
       FormBox[
        TemplateBox[{"1", 
          TemplateBox[{"10", 
            RowBox[{"-", "7"}]}, "Superscript", SyntaxForm -> 
           SuperscriptBox]}, "Row", 
         DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
         InterpretationFunction -> (RowBox[{"Row", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )],
         TraditionalForm]}, {-14.508657738524219`, 
       FormBox[
        TemplateBox[{"5", 
          TemplateBox[{"10", 
            RowBox[{"-", "7"}]}, "Superscript", SyntaxForm -> 
           SuperscriptBox]}, "Row", 
         DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
         InterpretationFunction -> (RowBox[{"Row", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )],
         TraditionalForm]}, {-13.815510557964274`, 
       FormBox[
        TemplateBox[{"1", 
          TemplateBox[{"10", 
            RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> 
           SuperscriptBox]}, "Row", 
         DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
         InterpretationFunction -> (RowBox[{"Row", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )],
         TraditionalForm]}, {-12.206072645530174`, 
       FormBox[
        TemplateBox[{"5", 
          TemplateBox[{"10", 
            RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> 
           SuperscriptBox]}, "Row", 
         DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
         InterpretationFunction -> (RowBox[{"Row", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )],
         TraditionalForm]}, {-20.030118656386467`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.624653548278303`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.33697147582652, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.931506367718356`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.7773556878911, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.643824295266576`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.526041259610192`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-17.72753356339242, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-17.322068455284256`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-17.034386382832476`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.62892127472431, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.474770594897052`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.34123920227253, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.223456166616145`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-15.424948470398375`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-15.01948336229021, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.73180128983843, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.326336181730264`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.172185501903007`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.038654109278484`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-13.9208710736221, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-13.122363377404328`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.716898269296165`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.429216196844383`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{-20.72326583694641, 
       FormBox["\"\"", TraditionalForm]}, {-19.11382792451231, 
       FormBox["\"\"", TraditionalForm]}, {-18.420680743952367`, 
       FormBox["\"\"", TraditionalForm]}, {-16.811242831518264`, 
       FormBox["\"\"", TraditionalForm]}, {-16.11809565095832, 
       FormBox["\"\"", TraditionalForm]}, {-14.508657738524219`, 
       FormBox["\"\"", TraditionalForm]}, {-13.815510557964274`, 
       FormBox["\"\"", TraditionalForm]}, {-12.206072645530174`, 
       FormBox["\"\"", TraditionalForm]}, {-20.030118656386467`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.624653548278303`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.33697147582652, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.931506367718356`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.7773556878911, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.643824295266576`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.526041259610192`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-17.72753356339242, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-17.322068455284256`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-17.034386382832476`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.62892127472431, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.474770594897052`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.34123920227253, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.223456166616145`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-15.424948470398375`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-15.01948336229021, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.73180128983843, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.326336181730264`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.172185501903007`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.038654109278484`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-13.9208710736221, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-13.122363377404328`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.716898269296165`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.429216196844383`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}, {Automatic, Automatic}},
  GridLines->{None, None},
  Method->{},
  PlotRange->{{
    0, 16627.584800000004`}, {-19.96424526948679, -14.53464762029868}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, {{-20.72326583694641, 
      FormBox[
       TemplateBox[{"1", 
         TemplateBox[{"10", 
           RowBox[{"-", "9"}]}, "Superscript", SyntaxForm -> SuperscriptBox]},
         "Row", DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
        InterpretationFunction -> (RowBox[{"Row", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )], 
       TraditionalForm]}, {-19.11382792451231, 
      FormBox[
       TemplateBox[{"5", 
         TemplateBox[{"10", 
           RowBox[{"-", "9"}]}, "Superscript", SyntaxForm -> SuperscriptBox]},
         "Row", DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
        InterpretationFunction -> (RowBox[{"Row", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )], 
       TraditionalForm]}, {-18.420680743952367`, 
      FormBox[
       TemplateBox[{"1", 
         TemplateBox[{"10", 
           RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> SuperscriptBox]},
         "Row", DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
        InterpretationFunction -> (RowBox[{"Row", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )], 
       TraditionalForm]}, {-16.811242831518264`, 
      FormBox[
       TemplateBox[{"5", 
         TemplateBox[{"10", 
           RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> SuperscriptBox]},
         "Row", DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
        InterpretationFunction -> (RowBox[{"Row", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )], 
       TraditionalForm]}, {-16.11809565095832, 
      FormBox[
       TemplateBox[{"1", 
         TemplateBox[{"10", 
           RowBox[{"-", "7"}]}, "Superscript", SyntaxForm -> SuperscriptBox]},
         "Row", DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
        InterpretationFunction -> (RowBox[{"Row", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )], 
       TraditionalForm]}, {-14.508657738524219`, 
      FormBox[
       TemplateBox[{"5", 
         TemplateBox[{"10", 
           RowBox[{"-", "7"}]}, "Superscript", SyntaxForm -> SuperscriptBox]},
         "Row", DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
        InterpretationFunction -> (RowBox[{"Row", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )], 
       TraditionalForm]}, {-13.815510557964274`, 
      FormBox[
       TemplateBox[{"1", 
         TemplateBox[{"10", 
           RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox]},
         "Row", DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
        InterpretationFunction -> (RowBox[{"Row", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )], 
       TraditionalForm]}, {-12.206072645530174`, 
      FormBox[
       TemplateBox[{"5", 
         TemplateBox[{"10", 
           RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox]},
         "Row", DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
        InterpretationFunction -> (RowBox[{"Row", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )], 
       TraditionalForm]}, {-20.030118656386467`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-19.624653548278303`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-19.33697147582652, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-18.931506367718356`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-18.7773556878911, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-18.643824295266576`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-18.526041259610192`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-17.72753356339242, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-17.322068455284256`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-17.034386382832476`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-16.62892127472431, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-16.474770594897052`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-16.34123920227253, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-16.223456166616145`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-15.424948470398375`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-15.01948336229021, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-14.73180128983843, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-14.326336181730264`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-14.172185501903007`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-14.038654109278484`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-13.9208710736221, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-13.122363377404328`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-12.716898269296165`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-12.429216196844383`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}}]], "Output",
 CellChangeTimes->{{3.541353935249116*^9, 3.541353956134061*^9}, {
   3.541353990333474*^9, 3.5413540349188147`*^9}, {3.541354067096858*^9, 
   3.5413540821304502`*^9}, 3.5413541454425287`*^9, 3.541355118278401*^9, {
   3.542456842080369*^9, 3.542456846717598*^9}, {3.542456882434832*^9, 
   3.542456903033482*^9}, 3.542456976904315*^9, 3.542457496398559*^9, {
   3.5424583462344646`*^9, 3.542458353218624*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 10", "Subtitle",
 CellChangeTimes->{{3.542455518606247*^9, 3.542455520857575*^9}}],

Cell["ii)", "Subsubtitle",
 CellChangeTimes->{{3.542458734434443*^9, 3.542458735252578*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   FractionBox[
    RowBox[{"4", "s"}], 
    RowBox[{"\[Alpha]", "^", "2"}]], "ee2mumu"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{"%", ",", "c", ",", "2"}], "]"}], "//", "FullSimplify"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Coefficient", "[", 
    RowBox[{
     RowBox[{"%%", "-", 
      RowBox[{"%", "*", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", "c", ",", "1"}], "]"}], "//",
    "FullSimplify"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%%", "/.", "LR2VA"}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%%", "/.", "LR2VA"}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%%", "/.", "VA2xWu"}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%%", "/.", "VA2xWu"}], "//", "FullSimplify"}]}], "Input",
 CellChangeTimes->{{3.542458787302706*^9, 3.542458800582581*^9}}],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"Absr2", " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["cAe", "2"], "+", 
     SuperscriptBox["cVe", "2"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["cAmu", "2"], "+", 
     SuperscriptBox["cVmu", "2"]}], ")"}]}], "+", 
  RowBox[{"2", " ", "cVe", " ", "cVmu", " ", "Rer"}]}]], "Output",
 CellChangeTimes->{{3.542458788525962*^9, 3.542458801060328*^9}}],

Cell[BoxData[
 RowBox[{"4", " ", "cAe", " ", "cAmu", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", "Absr2", " ", "cVe", " ", "cVmu"}], "+", "Rer"}], 
   ")"}]}]], "Output",
 CellChangeTimes->{{3.542458788525962*^9, 3.5424588010613527`*^9}}],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{
   FractionBox["1", "6"], " ", "Rer", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"4", " ", "xW"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "3"}], "+", 
     RowBox[{"8", " ", "xW"}]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "36"], " ", "Absr2", " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"4", " ", "xW"}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["xW", "2"]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"9", "+", 
     RowBox[{"8", " ", "xW", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        RowBox[{"4", " ", "xW"}]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{{3.542458788525962*^9, 3.5424588011470957`*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "6"}], " ", "Rer"}], "+", 
    RowBox[{"Absr2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"4", " ", "xW"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "+", 
       RowBox[{"8", " ", "xW"}]}], ")"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.542458788525962*^9, 3.542458801179082*^9}}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A0u", "[", "s_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"2", "*", 
      RowBox[{"Re", "[", 
       RowBox[{"r", "[", "s", "]"}], "]"}], "cVe", "*", "cVmu"}], "+", 
     RowBox[{
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"r", "[", "s", "]"}], "]"}], "^", "2"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"cVe", "^", "2"}], "+", 
        RowBox[{"cAe", "^", "2"}]}], ")"}], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["cAmu", "2"], "+", 
        SuperscriptBox["cVmu", "2"]}], ")"}]}]}], "/.", "VA2xWu"}], "/.", 
   "subs"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A1u", "[", "s_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"4", 
      RowBox[{"Re", "[", 
       RowBox[{"r", "[", "s", "]"}], "]"}], "cAe", "*", "cAmu"}], "+", 
     RowBox[{"8", 
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"r", "[", "s", "]"}], "]"}], "^", "2"}], "cVe", " ", "cVmu", 
      " ", "cAe", " ", "cAmu"}]}], "/.", "VA2xWu"}], "/.", 
   "subs"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A0d", "[", "s_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"2", "*", 
      RowBox[{"Re", "[", 
       RowBox[{"r", "[", "s", "]"}], "]"}], "cVe", "*", "cVmu"}], "+", 
     RowBox[{
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"r", "[", "s", "]"}], "]"}], "^", "2"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"cVe", "^", "2"}], "+", 
        RowBox[{"cAe", "^", "2"}]}], ")"}], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["cAmu", "2"], "+", 
        SuperscriptBox["cVmu", "2"]}], ")"}]}]}], "/.", "VA2xWd"}], "/.", 
   "subs"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A1d", "[", "s_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"4", 
      RowBox[{"Re", "[", 
       RowBox[{"r", "[", "s", "]"}], "]"}], "cAe", "*", "cAmu"}], "+", 
     RowBox[{"8", 
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"r", "[", "s", "]"}], "]"}], "^", "2"}], "cVe", " ", "cVmu", 
      " ", "cAe", " ", "cAmu"}]}], "/.", "VA2xWd"}], "/.", 
   "subs"}]}]}], "Input",
 CellChangeTimes->{{3.541355087943954*^9, 3.541355089536943*^9}, 
   3.541747052377713*^9, 3.54176502120772*^9, {3.542455826106526*^9, 
   3.542455907602364*^9}, {3.542456042912359*^9, 3.54245604548217*^9}, {
   3.542456241014434*^9, 3.5424562536364737`*^9}, {3.542457391421735*^9, 
   3.542457394408065*^9}, {3.542457593999712*^9, 3.542457596212287*^9}, {
   3.5424579967925587`*^9, 3.542458005694347*^9}, {3.542458186431979*^9, 
   3.542458223507481*^9}, {3.542458897574072*^9, 3.542458975287665*^9}, {
   3.5424590113422737`*^9, 3.542459019426311*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"\[Alpha]val", "^", "2"}], 
       RowBox[{"4", "*", 
        RowBox[{"34", "^", "2"}]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"A0", "[", 
          RowBox[{"34", "^", "2"}], "]"}], 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"A1", "[", 
          RowBox[{"34", "^", "2"}], "]"}], "c"}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[Alpha]val", "^", "2"}], 
       RowBox[{"4", "*", 
        RowBox[{"34", "^", "2"}]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"A0u", "[", 
          RowBox[{"34", "^", "2"}], "]"}], 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"A1u", "[", 
          RowBox[{"34", "^", "2"}], "]"}], "c"}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[Alpha]val", "^", "2"}], 
       RowBox[{"4", "*", 
        RowBox[{"34", "^", "2"}]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"A0d", "[", 
          RowBox[{"34", "^", "2"}], "]"}], 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"A1d", "[", 
          RowBox[{"34", "^", "2"}], "]"}], "c"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"\[Alpha]val", "^", "2"}], 
       RowBox[{"4", 
        RowBox[{"mZval", "^", "2"}]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"A0", "[", 
          RowBox[{"mZval", "^", "2"}], "]"}], 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"A1", "[", 
          RowBox[{"mZval", "^", "2"}], "]"}], "c"}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[Alpha]val", "^", "2"}], 
       RowBox[{"4", 
        RowBox[{"mZval", "^", "2"}]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"A0u", "[", 
          RowBox[{"mZval", "^", "2"}], "]"}], 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"A1u", "[", 
          RowBox[{"mZval", "^", "2"}], "]"}], "c"}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"\[Alpha]val", "^", "2"}], 
       RowBox[{"4", 
        RowBox[{"mZval", "^", "2"}]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"A0d", "[", 
          RowBox[{"mZval", "^", "2"}], "]"}], 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"A1d", "[", 
          RowBox[{"mZval", "^", "2"}], "]"}], "c"}]}], ")"}]}]}], 
    "\[IndentingNewLine]", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.5413542924703293`*^9, 3.541354344662171*^9}, {
  3.542456110714719*^9, 3.542456146611937*^9}, {3.542456184384749*^9, 
  3.5424561983401117`*^9}, {3.54245630938559*^9, 3.5424563750671053`*^9}, {
  3.542456413540618*^9, 3.5424564273026133`*^9}, {3.542456573880024*^9, 
  3.542456576496345*^9}, {3.542456642546097*^9, 3.542456655564066*^9}, {
  3.542456732543172*^9, 3.542456749968614*^9}, {3.5424576004784117`*^9, 
  3.54245760260083*^9}, {3.54245809854955*^9, 3.5424581034836407`*^9}, {
  3.542458988257854*^9, 3.542459116928627*^9}, {3.542459227104025*^9, 
  3.542459229121401*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt13k4Fe8XAHAlpWSrKGXfCV+0Ks7RpplbsuSWutaijSgpIkvaKJWilWTt
S5Zry7VlsnPJEt0saREida92JH7zfZ7fH/PM83memTPvnPec951R2edt6z5T
SEhogD7+Oxug7KfpaQE1wOKYZzWxwHtcLXx8QkDVx4aJWtezICffSPP7TwF1
aPK35/cqFhhrW+4bHBFQfUrvxUxLWbBG+nx30ysBVSjITOxIZ4H5h6/ce2wB
9SVPV1/tEgtsLz3PWOEsoMLryqtWbWSBX8v5owfL+ZSfDikwLNkLHR1inypc
v1An3Ka4WbF7QOGZ96I18p8pD47q58v37eGJR7WIZO8nyuHGlyrDtN3gEmk0
2hU2THUUiUatyNwFYzcDwykcoh6fSBbb3MiEZIk3cnffD1L8Pztt0vrsII5h
5NMeMUDtSIxwujXXDsI8Xf11yH4qoP2TwT/kTggUfuzn86WPqk/5ZXXtnC24
hrao89LeU/LeIm/2v7SBW08H7sYdeUdNGRCXmCttoOSt9vxM1TeUbrHfda8o
a1CTMt9oF99DRR27vyxrhjXk6YYf6fvQSfWnK32W6t8Bb2tylVev5lGR/x7+
GPzOEgb0bhlThe3USrdcj9MzLUE6OH21wYw2iij4pnVVazvorRbopX5voqq/
dwVWem+Dc5u/tBb711GHFdFLiGKAjF121J7FldSIVbqakjYD8jSvlGwRrqSC
LHQeyGoywHr8YL+RoILiS2+3klRnwOV4lbXz6iooH60Ax1nKDJgainlbcqqC
ErL0V/m7mAGDQYEG8rxnlHHY5FYdUQZ4Wd24+1SHoj7GqEt6DpOQ96tGsl69
hLrN+n4hlk3CtcdJlTBeTG2bteFXaRYJHk4hJ588L6YG1aR4vRkkqNeu7Uk6
VUxV1hn3a6SRcPtWxqOg+iJKISliXV0CCQErb5it8ORQRxKDWnbcJGGjj4NH
fH4BZcUNvn/8FAmpPQNXh89nU/Y1AwUim0joPiP78MGKbEqN15Mbu4EECcWt
OTZ9WVT1/n8ExuYknHJJe1GMWVTQT76uuxkJFgNHFl+eyKBGvrU86lxDwhBf
kKB7LJ2KYMrl/NEjQXfmRL4HK4UaKW4QNV5CglOybo3SvBQK3L2lR2VJuLmZ
xWsvSqb2X/XZy5YhYeJi2dh62WRKz+5GltFCEhrFQszmtyVSGaWG9lskSOjU
Fb2252o8FfDtV3naLBIcbeQLevbHUKunE144fyPg8/efJiero6ljyzWPbvtK
wJnbLZSERjSV6xK9fu0oAXE9YY0bBm9QxKCGrwyfgILGFzVWbdeoLsfldm+G
CWD/8FQb6j5P+U9xWtLfExDaod2xrMqMyhDpLNB6QYCeZO8REX117LN1ajJp
I4D3Neyh1BiBqulNiy1bCQiMtuB6rHTBgmOuDL9mAqqUIy49kPJB8PRQ7OYS
cPCg7oHCqTB8vmhGWFcVAcXzAl9WnozGt8tXrKEKCUjQl2lnq8agkfgi/uAT
Ai5as1vjWmKQY86UlKJtd/tD4ymd2+gSPxZ1IJ+AUZXtlbq9d1F7ZVWUeg4B
miYK7Jub4/FCw8Gw/nQC5jtwMkO+xqN8s+VbVdrfg20ee8Y/xI/qMY/2pRHg
0ldpq3YmAeUbNvgOPiLAQPu35d+XifhrRHn+dDIBDfnOm3MjUjA0lq/vG0+A
aY1elda7FHSs6jJseEBADm98Q/zqVPQy04hXon17PBqvfEhFfe1eTmssAW5Y
v87d7F9U7Gz9uOkeAdNcQyO5r+nYllhn4hVDwKq+GYpn7dl48vW31BdX6OeX
7P5qmM7G0HgdK0famjezqt+Ns/Gd6o8Vw5cJEEvMXJVgmYMPfTbnzKI9aW3/
epqfg0sMXpxghBPQm8PWoYzycKZMkqb0BQK64/YuXLw3D50mF0Wwz9PzFS7y
1yssDyUfLdOyot3swmpVbM/DE+b9MjfPEVAuNccv2DcfV97YV64ZRsDDY07V
ZpwCzEtauP5KCF0/DnOzb70tQGd25S4z2neJgjtf5jzBfcEi2aPBBEQpz/N4
YP8ED++3kGTRDm19Iv13/An6kk/iIIiuxzKXP3aqhdh4aOatiTME+KeJDWQy
CtGf8aGeQ/tYqGuRQ2whttu5fFhF29VQ3LnMlIPnLmz9YB5IgJN8EbHInYNh
HOOi2bT3iu439rzKwc6M3PrnAQTYvisSkX/DwfM9R+KcaW+McssMDCnCzl1c
iZunCVh3qCRkeWsRnk06lmVM29hcamePcjGG/HZf1+lPgNpo6fi6ymL0f2qm
ZEyb97hRIluuBJseqOx550fAZfceNZXjJXhpYZNjDG0z5ZG1MfUlmK5opr+D
9mj3hOUc5VI0pnzrxGnvtl7q/6W5FAOfrXGIP0Xnt8YkqT2oDF0Wy8hb0I7M
8f/1sOcp/q1RVOg5Sb9PLIfhaUKheOMNbhPtCqlXvrZDFAo1f3Mdor1oU6BV
3LZneF3TS30ZfX/938tuksnPsKhDeIE77cCi+6fDJp7h2c583VraHbdUZ5lq
VmBIyaqD07QNTjy+9tOmAgeMgr2AHl+4tbEcO6gCc+Cq+TnaffolyYfSK7Dv
3b7e57RNxTYaqL6swOAl05sV6XzcHmoo6hGqxNABVz9f2mRy1/Md9pVYjIGm
/+Xz7qFz0+vPVeLm2a9779Ae0tc30smuxBlHnRYJ0/MRXhQaIzyrCpcsqzf/
RNswlqkfIFeFTy8vjtCi57MzSLd21KAKj+1jrz5AW3tTx+/ePVX4hyyq+Ei7
/rkWq4hdhWnjBnf+/FcvOZPfDWqqsCC9Yu5mur6WRLdFpnZXYVNF3PurtA/Z
B5bfFKlGNV29Cg26HkU/NKscZVXjoR42HqDrd+vYySGVOTXIesZYp0vXO7+b
cfaufA0af90/I4L27adKSyWNa1D2co3+MO3BsIZtkw41OPuHa2EW3S8XxRXY
vLwaDEqbvriV7rda1eqTV5xqsSW6WaOc7kcvkXsSM31r8cQWrw0rIgiQHTr6
r39ELao776pMp30ga3GXe0EtZnCnv9+n+3n2Wg9T83l1aBvGkb0WScAWywXC
P5/UoYhvyR5OFAHXXOd+HW+ow6hOWUeTG3S+Tgq9neqtQ/8QiztltI/E80tE
Z9ejS4xSTu1N+noB10d+Vz1e7y46MUyvN503zvVt+lWPhzsvbTxMr0dHeD8q
bq7mouT9O1M29HqX/2mEfYfBxY0Mh9cTtCen+h7EOXGx3fTHaEoKHU+r7fSj
i1wUG35QPplKX++fZVTC42KPY+dICb2eTi49kPj+VCOOFQ1fPZ5NwHXnV6GG
nCbUWBU8WldC5+uzKQ42NWHqmtoN6aUEBJ9O+hvb14Ts2feEIsvofEUfDZgj
8RwPzntbyywnYEedsO8bt+e4L+3zyYkKAiT+MTwYuaAZL4KEU3gDPZ6pcMuh
oy14pf3IrsIuOv4Vvlj8uRYMPjh/T003HX+JHXfnvRacqlvb8LKHjm+stJWq
bsGHfKNvE70EaOXvVW4Ub0WPF6kHdvURMOfjqFySWyuu+hHdZTNCQN0OBXHr
BW14LiHi494puv8M3sv6yLfh2fIzIWHT9P4hnqoco9mGOQvGmBlC9P7dqLey
c10bJjpeKhcSJkGPNGW57G/DriDR4JI5JERtYqUfK2jDex9jCg9Lk7B37b0t
N3a9QGsXnjhHg4QvKjLBL+63Y8LgHztxWxLWBiYer0hpx5c6WtpBO0kI69B3
z8lux1+HvfT5diTIXrLYfq2yHf++s25u300CfPZbyvjUjuqP3Q9nOZJwvbC7
sMKkAxvTmmfdP0yC0bYEQU5nB17YHd9qH0bCSd/lrtdleZgYsLLMk0PHmyco
26XCw4VzF/zcUUxC0cO8JYp6PGypcbhtXErCJNekNXMDD6W5JgumyunxqBDI
9eRh019pQWot/b3W7KYgUsVD9QXrzUx4JDzSju8K8H6F9nzv5V6/SHj1Wsr2
QH0nNvi6WUmvZ4DLadOPc7b3YOqyoOaVXAZULV9zuUrkDUaKRVtcCtwGmnPL
hlKId5hQWtA9vGo7KJR5bBEJf4/dT+p4mkKWIDQxM92nrw9D+I66rK+W8Nvm
qVONRj8GYEry+OAO6FnpvEzj/AAuVL3dXy5sDcd2S0mrvh7Eng9nHbLjrEEu
pt9+lsIQjrLybx1fZQPZrIR/v/sPo8r9nGi5QRvYTW9y9U8/4Z7qs/VOt2wh
1+mo6rrJETwud8eyn7ETxuZtEi5mfkHngFbx3KV2YNu2frXCXT6uz7xe2DBo
B/PWi1WUPeAjR9HL3fuTHVSkdG9zSOaj0ZmgThm+HRj6n3aNzebj8jEDMfef
diChxImUq+Gjwo/XSfNnMaHB0/iDzDc+Lpp0iw1VYYK5qE6UxHYBrt6ukfvH
gQljx8eWZtsIsFRRZbDYhQnsnrpUy90CNH9t+dbfjQmK7AOlkfsEuG3JOsVx
DyZMMlMG550WoFuMY/PMQCZwkpXM5jwSYHJc6+9195jgJS6oe5QhQD2lHm+R
B0zQ9Cu3tcgVYGGkbGZrAhNiGI6HLpQJsEFb+fjhNCb4fL0fLdwuwJ9uwfop
HCboso4oJncKMBSl6nxLmfC+2iR94xsBzhdpV7egmGB9t7P87LAA1W1G9EZq
mSA6M41UEQgw95X5q3IuEygPv45nPwRoRtZtiW5mwqmXFs4uEwLkpgb7H3rB
hP//P+KeLwe8gceE/wFQWepu
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwt13k4Vev3AHANblKZ6lwphAqd5NJAKmtnSHsLISKnDHVToUQqJUNdF2mS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     "]]}, 
   {Hue[0.1421359549995791, 0.6, 0.6], LineBox[CompressedData["
1:eJwt13k0VV0bAPDiNWTWW4nMSuYXlTLtR1Kda8pwr9QtQ1F9KDKEVAqVIgoJ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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 1.15*^-8},
  PlotRange->{{-1, 1}, {1.1346874617893145`*^-8, 2.6009713921241544`*^-8}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.541354304724992*^9, 3.541354345324028*^9}, 
   3.5413550916300373`*^9, 3.542455912399139*^9, 3.542456048309568*^9, 
   3.5424561113509073`*^9, {3.542456147588266*^9, 3.542456156874117*^9}, 
   3.542456198976305*^9, 3.542456261060602*^9, 3.5424563111763363`*^9, {
   3.5424563480497713`*^9, 3.5424563758558693`*^9}, 3.542456428927944*^9, 
   3.542456522875592*^9, 3.542456577418768*^9, 3.542456645744712*^9, {
   3.5424567287359533`*^9, 3.542456750864715*^9}, 3.542457242064281*^9, 
   3.5424573970240593`*^9, {3.542457433529715*^9, 3.542457459763625*^9}, 
   3.542457547996149*^9, 3.542457603339952*^9, 3.542457668918545*^9, 
   3.54245785715975*^9, {3.542458094048625*^9, 3.542458104347435*^9}, {
   3.5424582410239677`*^9, 3.542458259953162*^9}, 3.5424589973131237`*^9, 
   3.542459118264213*^9, 3.5424592304719963`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt13k0ldsbB3BDZZar1HWVkDmEikx7Vwp1zbcu90bSIBdFMg+RVAgZ3oPM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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwt13k0ld33APAmQq+h3kzJmBASlZRyjqSBInmRKVOlgYiiDJWklFRCnmtW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     "]]}, 
   {Hue[0.1421359549995791, 0.6, 0.6], LineBox[CompressedData["
1:eJwt13k0Vd/7B3AfU1JJgyaSoYkkJUJ5jjSqpHwyRAmVimikwZhUEirJ54Zz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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 3.*^-7},
  PlotRange->{{-1, 1}, {3.035773499641624*^-7, 1.015955179676882*^-6}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.541354304724992*^9, 3.541354345324028*^9}, 
   3.5413550916300373`*^9, 3.542455912399139*^9, 3.542456048309568*^9, 
   3.5424561113509073`*^9, {3.542456147588266*^9, 3.542456156874117*^9}, 
   3.542456198976305*^9, 3.542456261060602*^9, 3.5424563111763363`*^9, {
   3.5424563480497713`*^9, 3.5424563758558693`*^9}, 3.542456428927944*^9, 
   3.542456522875592*^9, 3.542456577418768*^9, 3.542456645744712*^9, {
   3.5424567287359533`*^9, 3.542456750864715*^9}, 3.542457242064281*^9, 
   3.5424573970240593`*^9, {3.542457433529715*^9, 3.542457459763625*^9}, 
   3.542457547996149*^9, 3.542457603339952*^9, 3.542457668918545*^9, 
   3.54245785715975*^9, {3.542458094048625*^9, 3.542458104347435*^9}, {
   3.5424582410239677`*^9, 3.542458259953162*^9}, 3.5424589973131237`*^9, 
   3.542459118264213*^9, 3.542459230772818*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Au", "[", "s_", "]"}], ":=", 
  FractionBox[
   RowBox[{"3", 
    RowBox[{"A1u", "[", "s", "]"}]}], 
   RowBox[{"8", 
    RowBox[{"A0u", "[", "s", "]"}]}]]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ad", "[", "s_", "]"}], ":=", 
  FractionBox[
   RowBox[{"3", 
    RowBox[{"A1d", "[", "s", "]"}]}], 
   RowBox[{"8", 
    RowBox[{"A0d", "[", "s", "]"}]}]]}]}], "Input",
 CellChangeTimes->{{3.541354802739399*^9, 3.54135480559533*^9}, {
  3.541354872784093*^9, 3.541354901287347*^9}, {3.5424576123470373`*^9, 
  3.542457617249571*^9}, {3.542459182038514*^9, 3.5424591915472603`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"A", "[", "s", "]"}], "/.", "VA2xWmu"}], "/.", "subs"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Au", "[", "s", "]"}], "/.", "VA2xWmu"}], "/.", "subs"}], ",", 
     
     RowBox[{
      RowBox[{
       RowBox[{"Ad", "[", "s", "]"}], "/.", "VA2xWmu"}], "/.", "subs"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "0", ",", 
     RowBox[{"2", 
      RowBox[{"mZval", "^", "2"}]}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.541355552093319*^9, 3.541355561387374*^9}, {
   3.542457257118908*^9, 3.542457257328868*^9}, 3.5424575686992683`*^9, 
   3.542457619588642*^9, 3.5424582794904547`*^9, {3.542459198253994*^9, 
   3.542459209002398*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nk4VN8bAHBbKmVJktJiKaUUCVnSeUULEmVNkSRbJfVFhVRSigilRYoi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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k4VN8bAHAUrZZKUiKVaFGE7Ny3SNGiX5Zkj0JaUJEUIlS2L9KmpLIX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     "]]}, 
   {Hue[0.1421359549995791, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k4lF0UAHAVUSolXyklVJZSliT7PQqlRFlblK1oJZFkjSKRshWhUpbS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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 16627.584800000004`}, {-0.7378999941487664, 
    0.7492129311483423}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5413555618427353`*^9, 3.542457258077149*^9, 3.542457405678938*^9, {
   3.542457439734725*^9, 3.5424574792526493`*^9}, {3.542457559883627*^9, 
   3.542457569685629*^9}, 3.542457620172736*^9, 3.5424576762071238`*^9, 
   3.54245786663993*^9, 3.542458113867985*^9, {3.542458276905282*^9, 
   3.5424582808931417`*^9}, 3.5424592120517893`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["iii)", "Subsubtitle",
 CellChangeTimes->{{3.542458622438838*^9, 3.5424586239151497`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"R", "=", 
   FractionBox[
    RowBox[{
     RowBox[{"cLmu", "^", "2"}], "-", 
     RowBox[{"cRmu", "^", "2"}]}], 
    RowBox[{
     RowBox[{"cLmu", "^", "2"}], "+", 
     RowBox[{"cRmu", "^", "2"}]}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"R", "/.", "LR2VA"}], "/.", "VA2xWmu"}], "//", "FullSimplify"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"R", "/.", "LR2VA"}], "/.", "VA2xWu"}], "//", "FullSimplify"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"R", "/.", "LR2VA"}], "/.", "VA2xWd"}], "//", "FullSimplify"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   FractionBox["1", "%%%"], 
   RowBox[{"D", "[", 
    RowBox[{"%%%", ",", "xW"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   FractionBox["1", "%%%"], 
   RowBox[{"D", "[", 
    RowBox[{"%%%", ",", "xW"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   FractionBox["1", "%%%"], 
   RowBox[{"D", "[", 
    RowBox[{"%%%", ",", "xW"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"%%", "/", "%%%"}], ",", 
     RowBox[{"%", "/", "%%%"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"xW", ",", ".23", ",", ".24"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"%%%%", "/.", 
  RowBox[{"xW", "->", "xWval"}]}], "\[IndentingNewLine]", 
 RowBox[{"%%%%", "/.", 
  RowBox[{"xW", "->", "xWval"}]}], "\[IndentingNewLine]", 
 RowBox[{"%%%%", "/.", 
  RowBox[{"xW", "->", "xWval"}]}], "\[IndentingNewLine]", 
 RowBox[{"%%%", "/", "%"}]}], "Input",
 CellChangeTimes->{{3.5417639971191597`*^9, 3.5417641437159653`*^9}, {
  3.541764223088875*^9, 3.541764311449542*^9}, {3.541764345345974*^9, 
  3.541764405275537*^9}, {3.541764650053069*^9, 3.541764656849806*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVz3881HccB/BzlZKKVoo2kglF+VGGLV6OpTyW6ijpxyr94G4pXeUsV4l4
pBoXkaZ1+VHCfHDuh3OtuFSs9f1IP2gU665HP8bm5hHZivbtj/fj/Xg+Xv+8
XnO2xYfv5HI4nDD2Pv7o+KSOkr0MopRTXriJtXDr0GVfY61rFn69LkGL4QCz
FR2snWbGXEw5oIV0yrnGiSIGl+yCvmnfp8U1oioXsbbQpSclx2th02eUYB8D
fcd8nzaBFm2CWPuu/Qzs1glc9m3UgrdtjfCTRAaXY6UvygO1GKjiS8yPMHAR
qTYJTbUoqHcKykpj4Jf81PO31nq4qfsijScZkGFX3YSCekgntfc+yWbwrHdS
fNKWeryyz/eOOMdAGpGbVuBSj2lSyYeIi2w/q7TX+j4NXPpXz1xcysDjCRWa
1GqwaPKo4UIlgzXNj552JmlgkU49chTsvuSvMpgADfRasZellsFBkVVSiqkG
Mr1F6u5GBseiBxdYt9bBbcdd/tpmBu3SX+3rc+pQU7K1/TbDwLhJ8KfzhjqY
+lt33XjI7ll/8mLuZ3UIaWlcIOtiMOb3Ed/uHjUOTeV5j9EzCE+1v8G9osYx
5fNfBl4xWFYcecBKqMZRq63/7upn8ODRmxozdzVW3RtVxQ8x2MLtX9vTr8KE
w1mN4SMMZBdmifPkKtS9HExuGEOx9HHulS8TVfCtPNqgnkjRsD1qoMZHheqF
BoXPVArO/JX2tu+VsCz5Yih/JkWoLiYuUadEkIhoUu0ofDOtSnNSlPhu5J37
W0eK6yMpK+VLldhh2O085Eoh8vA6c2ysEsuv3ot76EURbFd23v+mAg5889gl
fhSthmWLzDIUoIHCZwsDKQI23t+cGKLA3r9llj+HUMRatfqOTlDgfeatTNMw
itUDvOmSu7VYf9ziVF8EhdVfoYUnTtaiMsDTf9MGCtkhc07Dilq0rRLHR0ZT
5I7Pcv7erBZ9dmciO2Mp+o0mh7fckeOfnsJT/nso5MZBc94PcrT81xbomkBR
VfTjq9zlcuQ96KwollBUzhZL55rJsch0fN6lVAp/PX/2rJs1uDrfkUk/QVHh
VGjKPVoDv8k2WqOUQvi4aNA7sAYnQj2dX5yl4BH/ZvFgNVqD54TuvEDRVd1j
MW9/NT64c+ubSii6dSaNfwxUgSM2La+soHB0evByRmwVhg/qw2bL2b6vk8ZO
e07QFLzOegnrUVuf6y3PCLIm39VHsS6Nux93pIdgbpEqMeej/S6Xve4kCG/J
KBpXS8GtVRQ0tBFUznAf7GW92MJbIGwg2KqQ/KRRUpDye6XKAgLXw8aYR6zb
0p6/E5wjGArZ6TnAOkxMl9qeJcjsXHnbVUVhK/lck55NoDVxMMpYn3a8MyMy
g2D66pbgdDWFovrO1TcJBD02/lOKWV8xt9tctp+gwiB/fJ21cjhocKOIgJd4
fvcwa8EODrcpjmCPbE/+rjqKcfm8vNPbCfwEhugM1h6nbbqDownGekW5XWY9
vqPx07ebCc7f4um6WetdDyV8u4EgRqo+9e5jXi7Ntowi8FrvGmmtoTDwRcVN
awlGHArtvVk7dNuXiSMIWvqm9/JZu4+TFc/jE/wPrmZogQ==
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwV0Xk41HkcB/BZaiotRheqtbJt2ihHFG16xzyr0+bYxGxaKkdb7pba6Tdm
hmGYrenYaLVNjkITqTTOSImm9PvKpgvRmqiYlS45Vva3f3yez/N6Ps/zeT7H
vO2R3sE6LBbLg4n/c1Dkr49yo2j4pvDdx0ZksH50/Ug1Y5VkrEqH8dCqKRsf
MVavj7CZPCyD3OBErV40DZcJcznTP8pQXaQ6F83Y3Da/fOE7GUy1A3zE0Kja
uDfPp0+G5rBQ87ZYGtyMgvf5bTK4bv9h17R4GkG9Uf7rr8rw9oIXf6qAxvjE
0XqrfTJkVixwO5REo8CbsyvciZmnVOs7kMbUP/XcpYfTIP/8YV/7ERrt3xRp
KlRpeGme4ehzgka0UqvUj0vDdDl/3Oc0DccuGbvHNg0LX3saO+TRsKyJePZE
m4ql+p80pwppdPLP2LgUpcJQQmyPltAoceOw54aloqsyzp5TSSOgV4QIy1Qo
ugzF4bU0PI87/KV5IYX1zrtem2/RYKvXjjbmSHExN/BhA02j7J87XJvtUrBd
TNputNA4ZzbSMDZHCnd17WJFG41Xa9a7ax+m4ICRq6NuF41io47+gPQUJF55
fvXtS6YuOhJv55kC4czA4d2vaawIWbriN4MUbLr3SRU5SCPunmqj661kTKYO
1XqP0eDo7Kg3ESWj7MWHhGu6BO2n8yoSkAynQuG1Uj2Cp00BgcuHJCheoilZ
bkQwXyQuFqsk4OQuG8wwJqjuMKoZipXALbqoXGxGYL+4cVxlLcHPY6M2H+cT
fLgYY2HYm4SdmnDLQSsC0/7g/PzsJKyturenxZ5g2ubD/qG8JFh4TQ1d6UxQ
v9c6vtE4CWT1rr+XrCYQBLVOCm5KRFS/gnPenSBwqGZzviwR/x6sP8j2YPrr
vos1XZcI/xRDmdaH4KePiY5lrEQUrrJz2cojaN3f4sCuFqN5U1ykbxCBSwPv
5r5YMbRmx3xbQwm6vc6zspeI8aYzS+YSQaD41uDOKPMz9UjzaqtfCE4semoQ
lS3C8futyhw+Qa3l7KqcrSIsZU86fkZMUMB9k95jJELVovm0JJXA9sceR3+1
EM76ppUDcgKzzhqPY4lCpK6zs+xJJ8hs7Z/S4iREE3feuuBTBGE3jJXXuxMw
bqNTUZdL4NV084sNWxPAimOfK1QS7NiXxqYbBBja3+Xx5SWCsvDM2cMrBKjj
bjFZyfgrkVxX6iTAIf27XX6M3eaY9MxaJsDX2ar4o4wPBGsyHOwE8FZLsyde
JpA/23Yh0lKAwlk2H/oYJz2j855PFyCwhP9n+RWC5tDim7e1FKyogZAHjMe5
jzu39FIYdA+2e8vYrvTw++4XFA62ft9gpWL27SjW09FQqPzMYkDBmHc795Xz
EwozPNVcSSlBzB73mIJ6Cp2mLgY5jNe2+y9YVkdBqbn0uIbxq5cj9+tqKbjG
nwwfYryY1z2ns4pChCIiY3cZQcBCv20zL1NwDtMESRnr6j3oyCmmMMHez/os
4wJZh59tEYWT9a7XOxgnD6Q7byigECIvlY0yzvz9u6zHZynY+1v5mpQz9+IJ
WSG5FMYssswdGd+Yt4b3LouCWjujz4uxsvGPIqGCwn/CKmwU
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0.23, 0},
  PlotRange->{{0.23, 0.24}, {0., 0.1033657132781668}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.5417640493334713`*^9, 3.541764095302112*^9}, 
   3.541764146530661*^9, {3.541764225386832*^9, 3.541764312505052*^9}, {
   3.541764351728945*^9, 3.541764406950883*^9}, 3.541764657479761*^9, 
   3.542455480674498*^9, 3.5424586262575893`*^9, 3.5424592574476137`*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztXAd8VFXW/6vYcXX3W3f10134SdNdF3RFZHd18be6IlIUCyLSEQkgodcg
NVIlEEAQQhJCCYQQQiAhRUIIEAIhEAglBUJMo6QA6WVSvnvOu2/yZjI3M1LU
/VZ+OpnMu/f08z/n3Pcm3QdNcBo6atCE4UMGNe88btAYp+FDxjd/a/Q48dE9
dwF3OQFIaQ56Xyfeypc68V/dcHqhT+rfd+cfT6HOdAW7JvXCyEWrsHBEL0wO
vgqTuFKePBsvNOuGPflFOO7UAo+3/Qc6deok/n8Nf/v7IBwurES23xi896kL
VniuxcIvPsRIr1SU1ZYo1teh5R3jyZqhrvo64nym480nn8Abc3bhSlUdWt1J
nlWXETSpN75YtBbfug7D4EWHcb3mzvI0XQ3BtF79MXOVJ76Z0R8fTw9Drul2
2FZtQxXNuy1DqSh2IJ7t6IlMIY4pYw06PPcZ4orJTPk4FXcBJTUkfjAmDPPG
+XKNXXXReWSVliLNdyVCr5j4s6qL7njhj10QeU21vkaq+/gd4ampdQ/qKtPg
1uEluKZUoPUd1LEwpj/+9PpWXK4W68vP4ct2L2BWcoU5jG4/zwokz2mLZ51O
oIRcXhKPz9q0w/zUCmnXR2+BZ42030MW9qNPFDRlFHXjH/eLVyHd7L+g1eB4
TbriY+jXsi3mCemaSM9UfL8d08e6IzrXJD97QLzWovDQMLT+0xgklGoSGda1
uiXyD1mSLylE3KzBGD97Pua7TkTXPzyFtyYuRdClypa3k01pBVJc2wk/JaCU
aJiy4PVyM3Q+cOP2sjEhZ+MbaN0jGHnCrTW5Qeja6k1szqlu4TCbX1uwYSCp
VRmpSEmrQSiUImFEazw7LhFltLT0FJzbtIHzqVLcy2se5CB0fvV9fH2iCLVc
7QR2BqzCmjVz0eed0diRUUGpLK40sV7bwmE2jzrEhlaWn/fAGI/zKDfEfiuH
+TzmIJ8ynJncGo93dEeKyD1TzlZ0af4ylqYZwu92saKUz8G2Ae3RZaobpr7d
HgO25aDqh1ivIStbVmqEjg2ESJnb1hBBceYIule6uq6uBrk7/4WnX1yGi5US
Y5rw1tQFf0XbsQm09W7bq1vcKqMHrRnx72k+U+B99iyWNIiLm2TzkBUbE7K8
OuLZPhvhs3IOnD/th6l+aSivrWt5uzkJFybNwIttp+F0WR1KEyej7YuzkVzx
A0z3mDUnmzZqhI5F93Efio4OwXMdvZAlq8srzw2try7/w8wKIgai+8IUlItP
io/2wTN/nomkcvF55EgM9ssRPU0NLvt1xB/+uRt5tar1eq9lh+VvboKlbMEq
M+E/zQXD/sI2aH2nFKxDZZobXnt1Fb7nJi8XketDcMncNN8RlsVxfdG6wzpu
Aqq+X4X2bQYivthBmzbG0qbttL7DNklYBVCd6Sr2uPTDOPd1cHPuA5fQXOpy
75HerC7Yj68GDsU8Dw/MG9gDzv4MgzDlhmFGP2cs8fwGU3p+DNfYG6ihbsj2
+paOcGv6Q7npLavpSgD6tGhnaFlvu151tWVI8ZmECYvXwXPRUHRz8kV2VV2r
O8StPA3rR/bGpBVecB8vRhCfdFQ4aMX7VNx0TDNai4PHNjUZJ6pJ+n+l7bVx
W4YhvXb7ca5TUtTxsN+DXh5Q73rkJ/qs6c9Ilp/TZ01/cdV/ymeNuOo1G5+9
6uA6Rz/7+bL/MZGOr/PlH52rreuv8Nv7UVNdg4qiMhTm5ON6xlXkJWfh8qk0
FF0uwK/s0Pgjv22O2ppaplFaUMR08s/nIDcpE9nHUpBx+CzS9p1EcvARnN0Z
g4RNkYj3CsPR1btxYPE2RM3zxXcz1mPPhDXYPXoVAj5bAv/+C7HlY1f4dP8S
3l2mYc1rY+Hx+nisf2cafHvNhd+n83ld0MjluLD3hD0xtZb9RSGmpmpJ7g0W
k1S9cjqdxbwYfQrnvzuOc0GHkei3n8U8+m0wYlfuZDEj52xiMUPGrq4Xc8Ai
FnPjezNZtLWdxmPNP8fy+w09ZvA1/4GLeW2w2Bc6cS3T2D9/C9MkE5ApiBeZ
JjnkKJsqM/YcsuNTWb6Ci5dY1rJrxagsLsPv1Lrm8etfYSqvZDXJgzcyc6VH
L2pq7q9X87T/AWZ9bF0oi3Lwa39EL/RjEcOmrGORA4ctQ8CQJazKpvdnmdVc
22kcv9/YcyZfCxj8NXY6ufOecBcv7J21gVU8vDyQaSds2otTW6KYb2p4PKuZ
FZeMnONSzQs5rGZpXiHLXmOqbqvWNFFqWllSjvLCkgaxqzs0bV+Cpul2qanH
HhzR4+4rLe5Cxn+L3c7fsJP8+i5gbdZ3dYHXW1M47jzfnMSabv5oDrZ+Ms8c
d6RpxHRvRM7eyPRilu1gTY+vD9ccGhiDpF2xrGn6wdMs09Uz37OMJG9J7nVN
0+qazmpNw6Sm1VUmGbrXtdBNyWJqRJWoExfipmcYSUHSxLjvYOnIHyQtSU3S
kxZb+8yD70dzWTvSkrT16jwFPl2nsxW2iSzk0B2zqj50F2xlemRFza+ROOm7
j62csidOC98jSWa/Xku/wvKSl6pKKwZZQ6EXf/ASXUNFYamlJxO1mE0/kGjW
78yOg5onPUPNCBItZCLZwqd6sn47h7ub9dO96f32VA1F/jWB9aVY5rgVsR3o
tEyLW7Gf6EQv8uNcIPoUMcSPcoV0pNyhHCK5KNJITpK36FIB+4dyb5rana5S
3Vt1JwVdvTtXaMErQJHAkd3578maO0UQk/qkKpmDg3fE8obqum3Xgtc73IxG
Sbstg5fcoatLMpO7KAFXqtXVZoz2YurS6kP5Ddu5mh6teZgsfCbgoAUqkbr7
pYd1VGrgYaFyox4epnmY9rPKAuV0AK73cLTZw2lRJ1muSycvWKqseXiHWuN3
+fVJVJVVaBgs4qIwWys1V89lMFXKD9I2NewYczy1ZR9O+ESwNIeWBrBkHM8C
R435Sg7mqthtOmt4NxebJ/m9nrPGyqhjMdEimofcAiwQingniarsiJOPqFVu
z68vayksVC6+fK0+pqXKGaKiEZuUUKny1igWIc4jRCs9S/yl2j4In6apTeWE
VCG1Nn8wm9Vc98bE+rimZkDAFztZrNsx1I33USNBKu+bu4lpxn6zC3FrQzQn
b9fSmAoDFQjrNGaoEkFKelDQZqrVflKqXZ/KWlORn5otep+MBr0PseVUlp6O
cQ+0bCxEHSKkJVW2D1qsNRY9tcaCYtqoNtUiveqa1ZYIHeW6Wau8K3Zq3hb8
9Hqkq06ISvJdOZOu1SMRocVXtXpkqqhCjVHtDqw2B7QVQF9KuMBkKF0uRGql
VgdovcWjsmhUk8TkxuLzpZp3e7uaUUuVwmQOXc3QSR4NeiiKIuKZuC3aosGg
RCP5SFZqSY0NhnAb+1Fzo/Tm0+x0+kcASiIYc2rXFyvMVZ8C1ZhTehun1wld
BAp8rvxnZeXPzjMjicgrFqH9/8v5wsHrsqG1f+O/RrFG+cBGE8c4O3KvWLVG
cQ/ZLufG70lqJ3YPN7qGVhjvWd7nCEv1ra675TBof02D+5BNtAlLD7t3LFRU
3USp52dvTYNbOg4ZV31srh9R276uPJ53kKviDNbMVXVdcdRrj+tPnbz/nZD1
i1V+ttf/46x2y+VPkmz43JtdxHqMf95C+bP1pNm99rg6UvoeUa9JyVU9uwSH
INpeeWva6BobT36wwjdX/po2usbG8wQOGdde6XtYeZ3JWd2BdpBl43VPeafT
1o1fexx/6oz978SpX6zys73+41lNv7lWVVVjvmDv5trf+O29qK6uQcKJHKxc
cRiffLwFW7ecsnt7qQO/vR+lpVWIjLyAObMj0e2d9XD6PBA+64/jwoUCPKrR
uB111Pbz8Mqy8pKULienEP7+pzF2TDDefssLkybuQVDQOeTmlvBjVLdn1FQ8
Zq2Urh2/fQA1NbU4e+Yq1q45igH9t+Hd7j5YMH8/DkSno6ys6nEp4C2W5dRC
1bO+6rL8vJSwvNyEgwfSsWhBNN7rsQH9+/phzeqjOJ14maR/wiChver9SCNr
8lVPncJqgm0j/ZqXV4pdwo9TJoeyX0c77+aozcq6QQdFBrM1XuYfaWRNieqZ
R7XZWkvxUlPzsN77OIYN3YGuXbwxa+ZefBdxHoWFFWhmEO9mR2Hl83VKyZ6R
Dq2srMbRI5lwW3IQH32wmdN9hXsM4uOzYTLVPGMh3M1OzIoHuZTCNZNmu3at
DCHByfjSJQLvvO2N4U6B2LwpAekXr8lnztR49LSkcfFiATZtTOC9ZPoZX36H
0D0puH69HM/ZofGE0UhHs7DM7RA+/sgXfXoLIy0/zEYS+Pq8HTKPG4I0eHcS
pk0NZ3Wcv9iFLb4nkZFxHS/YofFrA0QkJeXCc90xDB0SwBBL0RShRdNLdsj8
SpIhlN6//yLmz4viPO73qR9WrzrCqC/Qv4MdMg8b4HS7gNPxY0PQpbMXJowL
QcD20/z5322WvfsNeiSeuszgQVD3Qc+NWLQwmsFFQN1rdgTQv4pBCUSqU7Xp
0c3HXG1SUvJQW1v3uh0yd0k9qDhRkIwcEcSeme4SjuDgJBQUlOJNNY1qAyoe
jsnAkq+1JKIYWep2kBNLxE4jt4wrpQCXLxdhx44zXI90/KLQSE+/hq7q7aVS
ACrYJxMusQv1wjHPNYoLcUlJZQ81hSJJgdIhLDSFY4nS5LPBARxj585eJV/1
VFO4JikIcyNZRCaZn9xAkfnl9AiO+Pz80o/UFPIkBSEpovalcVD2fHcjBg3w
Z42OH88hLOptHVBXDOhK3qN8Itkpv3bJot5XzTZbshXhhujoixx+H76/ibOb
Op+4uCyR3dUD1BQypACUwNv8EjF29G4OH0oD6jKyswsxRL09zRA+sbEZWLb0
EOMvhRCF0sGD6XTtczWFVCsBiDEJQIJQ+KSlFWCEevs5Y/we1uKXYtcogLDO
KDWF01IA0nRHwBlMGN9QgLHq7Qk2LEDmJyEMAkxQU4i3YwGC/ynq7UcMMUDM
dAtQHFA8EEYKrHSxDr1DhqCn8CNWxJJy16D7TDXnaAOCUZrqQU/qkxnIH0Kq
OWoKkVYlgRJvhNNOBuLJE0PZH8Iv89QUIiQFqrOEonPnRDJ0UDXQM0Dg10I1
hT1GADp5iTtXgg5KQwLRoJ1nCduWqCnslhQoWQkqCDJ0ACJqRFVQX6ZRuA2j
g+JrrbaakUBDeB6JzWSbUMdLNiJbEWCKErHSQrabHxyU35W0JZs/vz7IEXjh
fL4WgXKqISAkQKSooOhYLQW81cGhRPXtPZsd8FZDaYncaxnh1G7K5PYwCHcr
M0Op6utjhplhgyFcT4nugyoc9eSEGFOnhOkp421hr5ufGCpU312yaS8fKRxh
6c7As+Y2kTKB2iQqg6Lb3GAQ7ubnBcWXY2zJ5WkozzpGfiJ8SL6kJoOQQyCI
r4VcNz0q2P4Whi251sgMoAinxkNvASgDqCGljKDGjjLETw1AqwwARIMBtZJG
EKTEFwAQoKaw3KqK0WgwoN82bkipn6JOUlAPUlNws6HKGGetnNBP+j1ZJnOw
msxiI5YKpsSchCBhSCgSTggZpqYw30oVI+KRYchAgvpeNYW5BlWoMvpuPmnu
i5xHabiUkpzH16Osy+osgwJ7QpLNviAFloupNObQ9wQZB9XspxuC9ZBY7b4s
hhV4/72N+Mp1H0O2mMNi1RSmSAp0cEYY4eV5DCOH7+SiRGXVf1siDaDH1BQm
SgrUe9Bq2kXqE9J4rI3jIUtQP6GmMFZSoIkxVEjsOncfpxt1h18vPoD9UWnU
OCSqKYxCfWNjjkkxGXTvqnXldOiVk114Tk1huMGRNAVs8DnBDtRjcuOGE+YC
k6Im87kUJFM0aDThuEwL59Fg8EB/fLMylmckEW1pagqDJQUxRCAiPJVPxKhD
7fXhZixcsB97vxP4U1CWYR1M/a1CgQLIbAKXCMbYzMwbOWrOfaQJaP6nWZ+c
5zQskDssQhiKbT2Wr6jJ9DJa8txVtpxeqimy1nkckzFRjXw1mQ+sLEn9lW5J
ci9NoKJXvaGm8K4hrMLDUjHvqygLS9KRlLBkiZpCV0mBulaamehEhNKre1cf
PlmRNq1QU+gsjUEIQ/3lt6uPYOhnAZwgNP3Sqd351Hw2lklN5g1Jhir56dNX
RHQe56GZXDNqZBC8veL5fEHMjdqob5tMJ4Nr6MyAuOvpSnV3lYhQWQCMBw82
ab0qbUMzu+4fijUCL7IT2auwUHv6yPjVOabSUW6mgwA68qL2kjCrdy9fPmwl
14gE4M2NHOO3N+QKbaGtBBoEHgSmVBVycrQ/wPKYmswLksyNG+WMNXSYobuZ
0IP6JKEmL/6tmszz0rqUgQTdVE0GD9rOUUvtFoEj9a5kfd7xezWtZyUtAjTC
DOqIjLlI54LysEKj9ZSaVktDDMYfyxYJGMdHP53/7ckdBAUPHafwvRNaq5/R
/oDpo6YYSRE+mP7Sb9GsrzsCYvK1/sb2Xlv9TXMD+lDvR83qFyK0CTboJ/1O
n1dUyNhsYSGlI3OIxqoYcX1b4xWvLPMjCoq9tqR8Wkqpl0uy3WjZutA0SphJ
NjZnUBsppSN/6+NhG9LZ/zMkRvGeMOAEhQe1H/ppJdVjgh8KJwor3vFng3jq
UUMtnp09PIb8xog6yRrq0J0LHXUoTyhfKG9YqHYWNlMNG43ZrPE9ljZ7zAoU
6VyF0pXSls7kqJDSLSkBZsa7a/ZGknrxinDkk1aWAdfoHkvxmhrEI/Sgkzaa
lahBI6wlsCLQIvDiHa9YiGd3MhGZezZwOaYO/hSjwnJRLdkq9tmS8AGDhHQC
RkfkWjXQWlmafunMR9RaTcJ/qLGqiQ1tdVo0otA0ZkGrk5FWUwta1hbTq5NB
Hl6oFVf5nLXGmv5RmOpxoBuazmvNrDsb993LkED/6H4SFT86ZuJ1jZxo8+sd
vaOOu/4PTId4RQ==\
\>"]],

Cell[BoxData[
 RowBox[{"-", "52.56467938025079`"}]], "Output",
 CellChangeTimes->{{3.5417640493334713`*^9, 3.541764095302112*^9}, 
   3.541764146530661*^9, {3.541764225386832*^9, 3.541764312505052*^9}, {
   3.541764351728945*^9, 3.541764406950883*^9}, 3.541764657479761*^9, 
   3.542455480674498*^9, 3.5424586262575893`*^9, 3.542459257452063*^9}],

Cell[BoxData[
 RowBox[{"-", "5.170552167498041`"}]], "Output",
 CellChangeTimes->{{3.5417640493334713`*^9, 3.541764095302112*^9}, 
   3.541764146530661*^9, {3.541764225386832*^9, 3.541764312505052*^9}, {
   3.541764351728945*^9, 3.541764406950883*^9}, 3.541764657479761*^9, 
   3.542455480674498*^9, 3.5424586262575893`*^9, 3.542459257452862*^9}],

Cell[BoxData[
 RowBox[{"-", "0.6798443501142426`"}]], "Output",
 CellChangeTimes->{{3.5417640493334713`*^9, 3.541764095302112*^9}, 
   3.541764146530661*^9, {3.541764225386832*^9, 3.541764312505052*^9}, {
   3.541764351728945*^9, 3.541764406950883*^9}, 3.541764657479761*^9, 
   3.542455480674498*^9, 3.5424586262575893`*^9, 3.5424592574540997`*^9}],

Cell[BoxData["77.31869709797205`"], "Output",
 CellChangeTimes->{{3.5417640493334713`*^9, 3.541764095302112*^9}, 
   3.541764146530661*^9, {3.541764225386832*^9, 3.541764312505052*^9}, {
   3.541764351728945*^9, 3.541764406950883*^9}, 3.541764657479761*^9, 
   3.542455480674498*^9, 3.5424586262575893`*^9, 3.542459257455543*^9}]
}, Open  ]],

Cell["\<\
One sees that the sensibility to the down type quarks is much smaller. I.e. \
one needs to modify a lot the couplings in order to accomodate a large \
discrepancy.\
\>", "Text",
 CellChangeTimes->{{3.542458645451473*^9, 3.542458725170926*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1438, 820},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Linux x86 (64-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 99, 1, 88, "Title"],
Cell[681, 25, 96, 1, 54, "Subtitle"],
Cell[780, 28, 278, 7, 50, "Input"],
Cell[1061, 37, 2795, 89, 107, "Input"],
Cell[3859, 128, 1908, 37, 107, "Input"],
Cell[5770, 167, 749, 17, 62, "Input"],
Cell[6522, 186, 706, 23, 88, "Input"],
Cell[CellGroupData[{
Cell[7253, 213, 146, 2, 31, "Subsubtitle"],
Cell[CellGroupData[{
Cell[7424, 219, 2091, 55, 137, "Input"],
Cell[9518, 276, 2861, 73, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12416, 354, 1230, 36, 170, "Input"],
Cell[13649, 392, 808, 17, 35, "Output"],
Cell[14460, 411, 728, 14, 33, "Output"],
Cell[15191, 427, 1011, 24, 47, "Output"],
Cell[16205, 453, 737, 15, 47, "Output"]
}, Open  ]],
Cell[16957, 471, 188, 2, 30, "Text"],
Cell[17148, 475, 1503, 42, 50, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18688, 522, 145, 2, 31, "Subsubtitle"],
Cell[CellGroupData[{
Cell[18858, 528, 2358, 70, 122, "Input"],
Cell[21219, 600, 10885, 183, 247, "Output"],
Cell[32107, 785, 10825, 183, 244, "Output"]
}, Open  ]],
Cell[42947, 971, 279, 5, 30, "Text"],
Cell[CellGroupData[{
Cell[43251, 980, 1267, 31, 30, "Input"],
Cell[44521, 1013, 2715, 50, 318, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47285, 1069, 94, 1, 31, "Subsubtitle"],
Cell[47382, 1072, 350, 10, 30, "Input"],
Cell[CellGroupData[{
Cell[47757, 1086, 605, 18, 93, "Input"],
Cell[48365, 1106, 186, 5, 47, "Output"],
Cell[48554, 1113, 186, 5, 47, "Output"],
Cell[48743, 1120, 161, 4, 47, "Output"]
}, Open  ]],
Cell[48919, 1127, 365, 10, 57, "Input"],
Cell[CellGroupData[{
Cell[49309, 1141, 472, 12, 30, "Input"],
Cell[49784, 1155, 10219, 174, 223, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[60052, 1335, 134, 3, 31, "Subsubtitle"],
Cell[60189, 1340, 159, 3, 30, "Text"],
Cell[60351, 1345, 906, 27, 50, "Input"],
Cell[CellGroupData[{
Cell[61282, 1376, 821, 23, 30, "Input"],
Cell[62106, 1401, 29531, 560, 224, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[91686, 1967, 97, 1, 54, "Subtitle"],
Cell[91786, 1970, 92, 1, 31, "Subsubtitle"],
Cell[CellGroupData[{
Cell[91903, 1975, 1044, 33, 170, "Input"],
Cell[92950, 2010, 429, 12, 33, "Output"],
Cell[93382, 2024, 250, 6, 30, "Output"],
Cell[93635, 2032, 795, 26, 47, "Output"],
Cell[94433, 2060, 481, 16, 47, "Output"]
}, Open  ]],
Cell[94929, 2079, 2745, 78, 97, "Input"],
Cell[CellGroupData[{
Cell[97699, 2161, 3938, 120, 166, "Input"],
Cell[101640, 2283, 15701, 264, 245, "Output"],
Cell[117344, 2549, 17177, 288, 245, "Output"]
}, Open  ]],
Cell[134536, 2840, 622, 17, 106, "Input"],
Cell[CellGroupData[{
Cell[135183, 2861, 794, 23, 30, "Input"],
Cell[135980, 2886, 30461, 508, 223, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[166478, 3399, 95, 1, 31, "Subsubtitle"],
Cell[CellGroupData[{
Cell[166598, 3404, 1888, 58, 341, "Input"],
Cell[168489, 3464, 11078, 189, 232, 3702, 67, "CachedBoxData", "BoxData", \
"Output"],
Cell[179570, 3655, 346, 5, 30, "Output"],
Cell[179919, 3662, 346, 5, 30, "Output"],
Cell[180268, 3669, 349, 5, 30, "Output"],
Cell[180620, 3676, 329, 4, 30, "Output"]
}, Open  ]],
Cell[180964, 3683, 253, 5, 30, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
